/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import schemacrawler.analysis.counts.TableRowCountsUtility;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.crawl.WeakAssociation;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.BaseForeignKey;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.DefinedObject;
import schemacrawler.schema.DependantObject;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.Grant;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineParameter;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseTabularFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import sf.util.Utility;

final class SchemaTextFormatter
extends BaseTabularFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    private static final String SPACE = " ";
    private final boolean isVerbose;
    private final boolean isBrief;

    private static String negate(boolean positive, String text) {
        String textValue = text;
        if (!positive) {
            textValue = "not " + textValue;
        }
        return textValue;
    }

    SchemaTextFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions, identifierQuoteString);
        this.isVerbose = schemaTextDetailType == SchemaTextDetailType.details;
        this.isBrief = schemaTextDetailType == SchemaTextDetailType.brief;
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            this.formattingHelper.writeObjectStart();
            this.printColumnDataType(columnDataType);
            this.formattingHelper.writeObjectEnd();
        }
    }

    @Override
    public void handle(Routine routine) {
        String routineTypeDetail = String.format("%s, %s", routine.getRoutineType(), routine.getReturnType());
        String routineName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName((NamedObject)routine) : this.identifiers.quoteFullName((DatabaseObject)routine);
        String routineType = "[" + routineTypeDetail + "]";
        this.formattingHelper.println();
        this.formattingHelper.println();
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeObjectNameRow(this.nodeId((DatabaseObject)routine), routineName, routineType, this.colorMap.getColor((DatabaseObject)routine));
        this.printRemarks((DatabaseObject)routine);
        if (!this.isBrief) {
            this.printRoutineParameters(routine.getParameters());
        }
        if (this.isVerbose) {
            String specificName;
            if (!((SchemaTextOptions)this.options).isHideRoutineSpecificNames() && !Utility.isBlank((CharSequence)(specificName = routine.getSpecificName()))) {
                this.formattingHelper.writeEmptyRow();
                this.formattingHelper.writeNameRow("", "[specific name]");
                this.formattingHelper.writeWideRow(this.identifiers.quoteName(specificName), "");
            }
            this.printDefinition((DefinedObject)routine);
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handle(Sequence sequence) {
        String sequenceName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName((NamedObject)sequence) : this.identifiers.quoteFullName((DatabaseObject)sequence);
        String sequenceType = "[sequence]";
        this.formattingHelper.println();
        this.formattingHelper.println();
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeObjectNameRow(this.nodeId((DatabaseObject)sequence), sequenceName, "[sequence]", this.colorMap.getColor((DatabaseObject)sequence));
        this.printRemarks((DatabaseObject)sequence);
        if (!this.isBrief) {
            this.formattingHelper.writeDetailRow("", "increment", String.valueOf(sequence.getIncrement()));
            this.formattingHelper.writeDetailRow("", "start value", Objects.toString(sequence.getStartValue(), ""));
            this.formattingHelper.writeDetailRow("", "minimum value", Objects.toString(sequence.getMinimumValue(), ""));
            this.formattingHelper.writeDetailRow("", "maximum value", Objects.toString(sequence.getMaximumValue(), ""));
            this.formattingHelper.writeDetailRow("", "cycle", String.valueOf(sequence.isCycle()));
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handle(Synonym synonym) {
        String synonymName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName((NamedObject)synonym) : this.identifiers.quoteFullName((DatabaseObject)synonym);
        String synonymType = "[synonym]";
        this.formattingHelper.println();
        this.formattingHelper.println();
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeObjectNameRow(this.nodeId((DatabaseObject)synonym), synonymName, "[synonym]", this.colorMap.getColor((DatabaseObject)synonym));
        this.printRemarks((DatabaseObject)synonym);
        if (!this.isBrief) {
            String referencedObjectName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName((NamedObject)synonym.getReferencedObject()) : this.identifiers.quoteFullName(synonym.getReferencedObject());
            this.formattingHelper.writeDetailRow("", String.format("%s %s %s", this.identifiers.quoteName((NamedObject)synonym), this.formattingHelper.createRightArrow(), referencedObjectName), "");
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handle(Table table) {
        String tableName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName((NamedObject)table) : this.identifiers.quoteFullName((DatabaseObject)table);
        String tableType = "[" + table.getTableType() + "]";
        this.formattingHelper.println();
        this.formattingHelper.println();
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeObjectNameRow(this.nodeId((DatabaseObject)table), tableName, tableType, this.colorMap.getColor((DatabaseObject)table));
        this.printRemarks((DatabaseObject)table);
        this.printTableColumns(table.getColumns(), true);
        if (this.isVerbose) {
            this.printTableColumns(new ArrayList(table.getHiddenColumns()), true);
        }
        this.printPrimaryKey(table.getPrimaryKey());
        this.printForeignKeys(table);
        if (!this.isBrief) {
            this.printWeakAssociations(table);
            this.printIndexes(table.getIndexes());
            this.printTriggers(table.getTriggers());
            this.printTableConstraints(table.getTableConstraints());
            if (this.isVerbose) {
                this.printPrivileges(table.getPrivileges());
                this.printDefinition((DefinedObject)table);
                this.printViewTableUsage(table);
            }
            this.printTableRowCount(table);
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Data Types");
        }
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Routines");
    }

    @Override
    public void handleSequencesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Sequences");
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Synonyms");
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Tables");
    }

    private void printColumnDataType(ColumnDataType columnDataType) {
        boolean isUserDefined = columnDataType.isUserDefined();
        String dataType = String.format("[%sdata type]", isUserDefined ? "user defined " : "");
        String typeName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnDataType.getName() : columnDataType.getFullName();
        if (Utility.isBlank((CharSequence)typeName)) {
            return;
        }
        String nullable = SchemaTextFormatter.negate(columnDataType.isNullable(), "nullable");
        String autoIncrementable = SchemaTextFormatter.negate(columnDataType.isAutoIncrementable(), "auto-incrementable");
        String createParameters = columnDataType.getCreateParameters();
        String definedWith = "defined with " + (Utility.isBlank((CharSequence)createParameters) ? "no parameters" : createParameters);
        this.formattingHelper.writeNameRow(typeName, dataType);
        this.formattingHelper.writeDescriptionRow(definedWith);
        this.formattingHelper.writeDescriptionRow(nullable);
        this.formattingHelper.writeDescriptionRow(autoIncrementable);
        this.formattingHelper.writeDescriptionRow(columnDataType.getSearchable().toString());
        if (isUserDefined) {
            ColumnDataType baseColumnDataType = columnDataType.getBaseType();
            String baseTypeName = baseColumnDataType == null ? "" : (((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? baseColumnDataType.getName() : baseColumnDataType.getFullName());
            this.formattingHelper.writeDetailRow("", "based on", baseTypeName);
            String remarks = columnDataType.getRemarks();
            if (!Utility.isBlank((CharSequence)remarks)) {
                this.formattingHelper.writeDetailRow("", "remarks", remarks);
            }
        }
    }

    private void printColumnReferences(boolean isForeignKey, Table table, BaseForeignKey<? extends ColumnReference> foreignKey) {
        MetaDataUtility.ForeignKeyCardinality fkCardinality = MetaDataUtility.findForeignKeyCardinality(foreignKey);
        for (ColumnReference columnReference : foreignKey) {
            String relationship;
            String arrow;
            String pkColumnName;
            Column pkColumn = columnReference.getPrimaryKeyColumn();
            Column fkColumn = columnReference.getForeignKeyColumn();
            boolean isIncoming = false;
            if (((Table)pkColumn.getParent()).equals(table)) {
                pkColumnName = this.identifiers.quoteName((NamedObject)pkColumn);
                isIncoming = true;
            } else {
                pkColumnName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteShortName((DependantObject)pkColumn) : this.identifiers.quoteFullName((DependantObject)pkColumn);
            }
            String fkColumnName = ((Table)fkColumn.getParent()).equals(table) ? this.identifiers.quoteName((NamedObject)fkColumn) : (((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteShortName((DependantObject)fkColumn) : this.identifiers.quoteFullName((DependantObject)fkColumn));
            String keySequenceString = "";
            if (columnReference instanceof ForeignKeyColumnReference && ((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                int keySequence = ((ForeignKeyColumnReference)columnReference).getKeySequence();
                keySequenceString = String.format("%2d", keySequence);
            }
            if (isIncoming) {
                String fkHyperlink = this.formattingHelper.createAnchor(fkColumnName, "#" + this.nodeId((DatabaseObject)fkColumn.getParent()));
                arrow = isForeignKey ? this.formattingHelper.createLeftArrow() : this.formattingHelper.createWeakLeftArrow();
                relationship = String.format("%s %s%s %s", pkColumnName, arrow, fkCardinality.toString(), fkHyperlink);
            } else {
                String pkHyperlink = this.formattingHelper.createAnchor(pkColumnName, "#" + this.nodeId((DatabaseObject)pkColumn.getParent()));
                arrow = isForeignKey ? this.formattingHelper.createRightArrow() : this.formattingHelper.createWeakRightArrow();
                relationship = String.format("%s %s%s %s", fkColumnName, fkCardinality.toString(), arrow, pkHyperlink);
            }
            this.formattingHelper.writeDetailRow(keySequenceString, relationship, "", false, false, "");
        }
    }

    private void printDefinition(DefinedObject definedObject) {
        if (definedObject == null || !definedObject.hasDefinition()) {
            return;
        }
        if (!this.isVerbose) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Definition", "section");
        this.formattingHelper.writeNameRow("", "[definition]");
        this.formattingHelper.writeWideRow(definedObject.getDefinition(), "definition");
    }

    private void printDependantObjectDefinition(DefinedObject definedObject) {
        if (definedObject == null || !definedObject.hasDefinition()) {
            return;
        }
        if (!this.isVerbose) {
            return;
        }
        this.formattingHelper.writeWideRow(definedObject.getDefinition(), "definition");
    }

    private void printForeignKeys(Table table) {
        Collection foreignKeysCollection = table.getForeignKeys();
        if (foreignKeysCollection.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Foreign Keys", "section");
        ArrayList foreignKeys = new ArrayList(foreignKeysCollection);
        Collections.sort(foreignKeys, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForForeignKeys()));
        for (ForeignKey foreignKey : foreignKeys) {
            if (foreignKey == null) continue;
            String name = this.identifiers.quoteName((NamedObject)foreignKey);
            String updateRuleString = "";
            ForeignKeyUpdateRule updateRule = foreignKey.getUpdateRule();
            if (updateRule != null && updateRule != ForeignKeyUpdateRule.unknown) {
                updateRuleString = ", on update " + updateRule.toString();
            }
            String deleteRuleString = "";
            ForeignKeyUpdateRule deleteRule = foreignKey.getDeleteRule();
            if (deleteRule != null && deleteRule != ForeignKeyUpdateRule.unknown) {
                deleteRuleString = ", on delete " + deleteRule.toString();
            }
            String ruleString = deleteRule != null && updateRule == deleteRule && updateRule != ForeignKeyUpdateRule.unknown ? ", with " + deleteRule.toString() : updateRuleString + deleteRuleString;
            this.formattingHelper.writeEmptyRow();
            String fkName = "";
            if (!((SchemaTextOptions)this.options).isHideForeignKeyNames()) {
                fkName = name;
            }
            String fkDetails = "[foreign key" + ruleString + "]";
            this.formattingHelper.writeNameRow(fkName, fkDetails);
            this.printColumnReferences(true, table, (BaseForeignKey<? extends ColumnReference>)foreignKey);
            this.printDependantObjectDefinition((DefinedObject)foreignKey);
        }
    }

    private void printIndexes(Collection<Index> indexesCollection) {
        if (indexesCollection.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Indexes", "section");
        ArrayList<Index> indexes = new ArrayList<Index>(indexesCollection);
        Collections.sort(indexes, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes()));
        for (Index index : indexes) {
            if (index == null) continue;
            this.formattingHelper.writeEmptyRow();
            String indexName = "";
            if (!((SchemaTextOptions)this.options).isHideIndexNames()) {
                indexName = this.identifiers.quoteName((NamedObject)index);
            }
            IndexType indexType = index.getIndexType();
            String indexTypeString = "";
            if (indexType != IndexType.unknown && indexType != IndexType.other) {
                indexTypeString = indexType.toString() + SPACE;
            }
            String indexDetails = "[" + (index.isUnique() ? "" : "non-") + "unique " + indexTypeString + "index]";
            this.formattingHelper.writeNameRow(indexName, indexDetails);
            this.printRemarks((DatabaseObject)index);
            if (!this.isBrief) {
                this.printTableColumns(index.getColumns(), false);
            }
            this.printDependantObjectDefinition((DefinedObject)index);
        }
    }

    private void printPrimaryKey(PrimaryKey primaryKey) {
        if (primaryKey != null) {
            this.formattingHelper.writeEmptyRow();
            this.formattingHelper.writeWideRow("Primary Key", "section");
            this.formattingHelper.writeEmptyRow();
            String name = this.identifiers.quoteName((NamedObject)primaryKey);
            String pkName = "";
            if (!((SchemaTextOptions)this.options).isHidePrimaryKeyNames()) {
                pkName = name;
            }
            if (Utility.isBlank((CharSequence)pkName)) {
                pkName = "";
            }
            this.formattingHelper.writeNameRow(pkName, "[primary key]");
            this.printRemarks((DatabaseObject)primaryKey);
            this.printTableColumns(primaryKey.getColumns(), false);
            this.printDependantObjectDefinition((DefinedObject)primaryKey);
        }
    }

    private void printViewTableUsage(Table table) {
        if (table == null || !(table instanceof View)) {
            return;
        }
        View view = (View)table;
        Collection tableUsage = view.getTableUsage();
        if (tableUsage.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Table Usage", "section");
        this.formattingHelper.writeEmptyRow();
        for (Table usedTable : tableUsage) {
            String tableName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName((NamedObject)usedTable) : this.identifiers.quoteFullName((DatabaseObject)usedTable);
            String tableType = "[" + usedTable.getTableType() + "]";
            this.formattingHelper.writeNameRow(tableName, tableType);
        }
    }

    private void printPrivileges(Collection<Privilege<Table>> privileges) {
        if (privileges.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Privileges and Grants", "section");
        for (Privilege<Table> privilege : privileges) {
            if (privilege == null) continue;
            this.formattingHelper.writeEmptyRow();
            this.formattingHelper.writeNameRow(privilege.getName(), "[privilege]");
            for (Grant grant : privilege.getGrants()) {
                String grantor = Utility.isBlank((CharSequence)grant.getGrantor()) ? "" : grant.getGrantor();
                String grantee = Utility.isBlank((CharSequence)grant.getGrantee()) ? "" : grant.getGrantee();
                String grantedFrom = String.format("%s %s %s%s", grantor, this.formattingHelper.createRightArrow(), grantee, grant.isGrantable() ? " (grantable)" : "");
                this.formattingHelper.writeDetailRow("", grantedFrom, "");
            }
        }
    }

    private void printRemarks(DatabaseObject object) {
        if (object == null || !object.hasRemarks() || ((SchemaTextOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.writeWideRow(object.getRemarks(), "remarks");
    }

    private void printRoutineParameters(List<? extends RoutineParameter<?>> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        parameters.sort((Comparator<RoutineParameter<?>>)NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForRoutineParameters()));
        for (RoutineParameter<?> parameter : parameters) {
            String columnTypeName = ((SchemaTextOptions)this.options).isShowStandardColumnTypeNames() ? parameter.getColumnDataType().getJavaSqlType().getName() : parameter.getColumnDataType().getDatabaseSpecificTypeName();
            StringBuilder columnType = new StringBuilder(64);
            columnType.append(columnTypeName).append(parameter.getWidth());
            if (parameter.getParameterMode() != null) {
                columnType.append(", ").append(parameter.getParameterMode().toString());
            }
            String ordinalNumberString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                ordinalNumberString = String.valueOf(parameter.getOrdinalPosition() + 1);
            }
            this.formattingHelper.writeDetailRow(ordinalNumberString, this.identifiers.quoteName(parameter), columnType.toString());
        }
    }

    private void printTableColumnAutoIncremented(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isAutoIncremented()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        this.formattingHelper.writeDetailRow("", "", "auto-incremented");
    }

    private void printTableColumnGenerated(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isGenerated()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        this.formattingHelper.writeDetailRow("", "", "generated");
    }

    private void printTableColumnHidden(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isHidden()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        this.formattingHelper.writeDetailRow("", "", "hidden");
    }

    private void printTableColumnRemarks(Column column) {
        if (column == null || !column.hasRemarks() || ((SchemaTextOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.writeDetailRow("", "", column.getRemarks(), true, false, "remarks");
    }

    private void printTableColumns(List<? extends Column> columns, boolean extraDetails) {
        if (columns.isEmpty()) {
            return;
        }
        Collections.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForTableColumns()));
        for (Column column : columns) {
            String columnDetails;
            if (this.isBrief && !this.isColumnSignificant(column)) continue;
            String columnName = this.identifiers.quoteName((NamedObject)column);
            boolean emphasize = false;
            if (column instanceof IndexColumn) {
                columnDetails = ((IndexColumn)column).getSortSequence().name();
            } else if (column instanceof TableConstraintColumn) {
                columnDetails = "";
            } else {
                String columnTypeName = ((SchemaTextOptions)this.options).isShowStandardColumnTypeNames() ? column.getColumnDataType().getJavaSqlType().getName() : column.getColumnDataType().getDatabaseSpecificTypeName();
                String columnType = columnTypeName + column.getWidth();
                String nullable = this.columnNullable(columnTypeName, column.isNullable());
                columnDetails = columnType + nullable;
                emphasize = column.isPartOfPrimaryKey();
            }
            String ordinalNumberString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                ordinalNumberString = String.valueOf(column.getOrdinalPosition());
            }
            this.formattingHelper.writeDetailRow(ordinalNumberString, columnName, columnDetails, true, emphasize, "");
            if (!extraDetails) continue;
            this.printTableColumnEnumValues(column);
            this.printTableColumnHidden(column);
            this.printTableColumnAutoIncremented(column);
            this.printTableColumnGenerated(column);
            this.printTableColumnRemarks(column);
            if (!(column instanceof DefinedObject)) continue;
            this.printDependantObjectDefinition((DefinedObject)column);
        }
    }

    private void printTableColumnEnumValues(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.getColumnDataType().isEnumerated()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        String enumValues = String.format("'%s'", String.join((CharSequence)"', ", column.getColumnDataType().getEnumValues()));
        this.formattingHelper.writeDetailRow("", "", enumValues);
    }

    private void printTableConstraints(Collection<TableConstraint> constraintsCollection) {
        EnumSet<TableConstraintType> printableConstraints = EnumSet.of(TableConstraintType.check, TableConstraintType.unique);
        ArrayList<TableConstraint> constraints = new ArrayList<TableConstraint>();
        for (TableConstraint constraint : constraintsCollection) {
            if (!printableConstraints.contains(constraint.getConstraintType())) continue;
            constraints.add(constraint);
        }
        if (constraints.isEmpty()) {
            return;
        }
        Collections.sort(constraints, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes()));
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Table Constraints", "section");
        for (TableConstraint constraint : constraints) {
            if (constraint == null) continue;
            String constraintName = "";
            if (!((SchemaTextOptions)this.options).isHideTableConstraintNames()) {
                constraintName = this.identifiers.quoteName((NamedObject)constraint);
            }
            String constraintType = constraint.getConstraintType().getValue().toLowerCase();
            String constraintDetails = "[" + constraintType + " constraint]";
            this.formattingHelper.writeEmptyRow();
            this.formattingHelper.writeNameRow(constraintName, constraintDetails);
            if (!this.isBrief) {
                this.printTableColumns(constraint.getColumns(), false);
            }
            this.printDependantObjectDefinition((DefinedObject)constraint);
        }
    }

    private void printTableRowCount(Table table) {
        if (!((SchemaTextOptions)this.options).isShowRowCounts() || table == null || !TableRowCountsUtility.hasRowCount((Table)table)) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Additional Information", "section");
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeNameRow(TableRowCountsUtility.getRowCountMessage((Table)table), "[row count]");
    }

    private void printTriggers(Collection<Trigger> triggers) {
        if (triggers.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Triggers", "section");
        for (Trigger trigger : triggers) {
            if (trigger == null) continue;
            String timing = "";
            ConditionTimingType conditionTiming = trigger.getConditionTiming();
            EventManipulationType eventManipulationType = trigger.getEventManipulationType();
            if (conditionTiming != null && conditionTiming != ConditionTimingType.unknown && eventManipulationType != null && eventManipulationType != EventManipulationType.unknown) {
                timing = ", " + conditionTiming + SPACE + eventManipulationType;
            }
            String orientation = "";
            if (trigger.getActionOrientation() != null && trigger.getActionOrientation() != ActionOrientationType.unknown) {
                orientation = ", per " + trigger.getActionOrientation();
            }
            String triggerType = "[trigger" + timing + orientation + "]";
            triggerType = triggerType.toLowerCase(Locale.ENGLISH);
            String actionCondition = trigger.getActionCondition();
            String actionStatement = trigger.getActionStatement();
            this.formattingHelper.writeEmptyRow();
            String triggerName = ((SchemaTextOptions)this.options).isHideTriggerNames() ? "" : this.identifiers.quoteName((NamedObject)trigger);
            this.formattingHelper.writeNameRow(triggerName, triggerType);
            if (!Utility.isBlank((CharSequence)actionCondition)) {
                this.formattingHelper.writeWideRow(actionCondition, "definition");
            }
            if (Utility.isBlank((CharSequence)actionStatement)) continue;
            this.formattingHelper.writeWideRow(actionStatement, "definition");
        }
    }

    private void printWeakAssociations(Table table) {
        if (!((SchemaTextOptions)this.options).isShowWeakAssociations()) {
            return;
        }
        Collection weakAssociationsCollection = table.getWeakAssociations();
        if (weakAssociationsCollection.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Weak Associations", "section");
        ArrayList weakAssociations = new ArrayList(weakAssociationsCollection);
        weakAssociations.sort(Comparator.naturalOrder());
        for (WeakAssociation weakFk : weakAssociations) {
            if (weakFk == null) continue;
            this.formattingHelper.writeEmptyRow();
            String fkDetails = "[weak association]";
            this.formattingHelper.writeNameRow("", "[weak association]");
            this.printColumnReferences(false, table, (BaseForeignKey<? extends ColumnReference>)weakFk);
        }
    }
}

