/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.scheduler;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Objects;

final class TimedTaskResult
implements Serializable {
    private static final long serialVersionUID = -6572177882937039431L;
    private static final DateTimeFormatter df = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, true).toFormatter();
    private final Duration duration;
    private final String taskName;

    TimedTaskResult(String taskName, Duration duration) {
        Objects.requireNonNull(taskName, "Task name not provided");
        Objects.requireNonNull(duration, "Duration not provided");
        this.taskName = taskName;
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String toString() {
        LocalTime durationLocal = LocalTime.ofNanoOfDay(this.duration.toNanos());
        return String.format("%s - <%s>", durationLocal.format(df), this.taskName);
    }
}

