/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.scheduler;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TimedTaskResult;
import us.fatehi.utility.string.StringFormat;

class TimedTask
implements Callable<TimedTaskResult> {
    private static final Logger LOGGER = Logger.getLogger(TimedTask.class.getName());
    private final TaskDefinition taskDefinition;
    private final Clock clock;

    TimedTask(TaskDefinition task, Clock clock) {
        this.taskDefinition = Objects.requireNonNull(task, "Task not provided");
        this.clock = Objects.requireNonNull(clock, "Clock not provided");
    }

    @Override
    public TimedTaskResult call() {
        LOGGER.log(Level.INFO, new StringFormat("Running <%s> on thread <%s>", this.taskDefinition.getTaskName(), Thread.currentThread().getName()));
        Instant start = Instant.now(this.clock);
        Exception ex = null;
        try {
            this.taskDefinition.getTask().run();
        }
        catch (Exception e) {
            ex = e;
        }
        Instant stop = Instant.now(this.clock);
        Duration runTime = Duration.between(start, stop);
        TimedTaskResult timedTaskResult = new TimedTaskResult(this.taskDefinition.getTaskName(), runTime, ex);
        if (ex != null) {
            LOGGER.log(Level.WARNING, String.format("Exception running <%s> on thread <%s>: %s", timedTaskResult, Thread.currentThread().getName(), ex.getMessage()), ex);
        }
        return timedTaskResult;
    }
}

