/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.collections;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CircularBoundedList<T>
implements Iterable<T> {
    private final Object[] elements;
    private int size;
    private int head;
    private int tail;
    private boolean isFull;

    public CircularBoundedList(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be a positive integer");
        }
        this.elements = new Object[capacity];
        this.size = 0;
        this.head = 0;
        this.tail = 0;
        this.isFull = false;
    }

    public void add(T element) {
        this.elements[this.tail] = element;
        this.tail = (this.tail + 1) % this.elements.length;
        if (this.size < this.elements.length) {
            ++this.size;
        } else {
            this.head = (this.head + 1) % this.elements.length;
        }
        this.isFull = this.size == this.elements.length;
    }

    public List<T> convertToList() {
        return StreamSupport.stream(this.spliterator(), false).collect(Collectors.toList());
    }

    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index");
        }
        int actualIndex = (this.head + index) % this.elements.length;
        return (T)this.elements[actualIndex];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.isFull;
    }

    @Override
    public Iterator<T> iterator() {
        return new CyclicalBoundedListIterator();
    }

    public int size() {
        return this.size;
    }

    private class CyclicalBoundedListIterator
    implements Iterator<T> {
        private int currentIndex;
        private int remainingElements;

        public CyclicalBoundedListIterator() {
            this.currentIndex = CircularBoundedList.this.head;
            this.remainingElements = CircularBoundedList.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.remainingElements > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No more elements");
            }
            Object element = CircularBoundedList.this.elements[this.currentIndex];
            this.currentIndex = (this.currentIndex + 1) % CircularBoundedList.this.elements.length;
            --this.remainingElements;
            return element;
        }
    }
}

