/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Reducer;

abstract class BaseReducer<N extends NamedObject>
implements Reducer<N> {
    private final Predicate<N> filter;

    protected BaseReducer(Predicate<N> filter) {
        this.filter = Objects.requireNonNull(filter);
    }

    @Override
    public void reduce(Collection<? extends N> allNamedObjects) {
        if (allNamedObjects != null) {
            HashSet<NamedObject> keepList = new HashSet<NamedObject>();
            for (NamedObject namedObject : allNamedObjects) {
                if (!this.filter.test(namedObject)) continue;
                keepList.add(namedObject);
            }
            allNamedObjects.retainAll(keepList);
        }
    }
}

