/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;

abstract class MutableRoutine
extends AbstractDatabaseObject
implements Routine {
    private static final long serialVersionUID = 3906925686089134130L;
    private String specificName;
    private RoutineBodyType routineBodyType = RoutineBodyType.unknown;
    private final StringBuilder definition = new StringBuilder();

    MutableRoutine(Schema schema, String name) {
        super(schema, name);
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public RoutineBodyType getRoutineBodyType() {
        return this.routineBodyType;
    }

    @Override
    public String getSpecificName() {
        return this.specificName;
    }

    @Override
    public final RoutineType getType() {
        return this.getRoutineType();
    }

    @Override
    public boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public List<String> toUniqueLookupKey() {
        ArrayList<String> lookupKey = new ArrayList<String>(super.toUniqueLookupKey());
        lookupKey.add(this.specificName);
        return lookupKey;
    }

    void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    void setRoutineBodyType(RoutineBodyType routineBodyType) {
        this.routineBodyType = routineBodyType;
    }

    void setSpecificName(String specificName) {
        this.specificName = specificName;
    }
}

