/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.schema.NamedObject;
import sf.util.ObjectToString;

class NamedObjectList<N extends NamedObject>
implements Serializable,
Collection<N> {
    private static final long serialVersionUID = 3257847666804142128L;
    private final Map<List<String>, N> objects = new HashMap<List<String>, N>();

    NamedObjectList() {
    }

    private static List<String> makeLookupKey(NamedObject namedObject) {
        List<String> key = namedObject == null ? null : namedObject.toUniqueLookupKey();
        return key;
    }

    private static List<String> makeLookupKey(NamedObject namedObject, String name) {
        List<String> key = NamedObjectList.makeLookupKey(namedObject);
        key.add(name);
        return key;
    }

    private static List<String> makeLookupKey(String fullName) {
        String[] lookupKey;
        ArrayList<String> key = new ArrayList<String>();
        if (fullName == null) {
            return key;
        }
        for (String string : lookupKey = fullName.split("\\.(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")) {
            key.add(string.replace("\"", ""));
        }
        return key;
    }

    @Override
    public boolean add(N namedObject) {
        Objects.requireNonNull(namedObject, "Cannot add a null object to the list");
        List<String> key = NamedObjectList.makeLookupKey(namedObject);
        this.objects.put(key, namedObject);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends N> c) {
        throw new UnsupportedOperationException("Bulk operations are not supported");
    }

    @Override
    public void clear() {
        this.objects.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.objects.containsKey(NamedObjectList.makeLookupKey((NamedObject)object));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public Iterator<N> iterator() {
        return this.values().iterator();
    }

    @Override
    public boolean remove(Object object) {
        NamedObject removedObject = (NamedObject)this.objects.remove(NamedObjectList.makeLookupKey((NamedObject)object));
        return removedObject != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        boolean modified = false;
        for (NamedObject namedObject : this) {
            if (namedObject == null || !c.contains(namedObject)) continue;
            List<String> key = NamedObjectList.makeLookupKey(namedObject);
            this.objects.remove(key);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        boolean modified = false;
        for (NamedObject namedObject : this) {
            if (namedObject == null || c.contains(namedObject)) continue;
            List<String> key = NamedObjectList.makeLookupKey(namedObject);
            this.objects.remove(key);
            modified = true;
        }
        return modified;
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public Object[] toArray() {
        return this.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.values().toArray(a);
    }

    public String toString() {
        return ObjectToString.toString(this.values());
    }

    Optional<N> lookup(List<String> lookupKey) {
        return this.internalGet(lookupKey);
    }

    Optional<N> lookup(NamedObject namedObject, String name) {
        List<String> key = NamedObjectList.makeLookupKey(namedObject, name);
        return this.internalGet(key);
    }

    Optional<N> lookup(String fullName) {
        return this.internalGet(NamedObjectList.makeLookupKey(fullName));
    }

    N remove(N namedObject) {
        return (N)((NamedObject)this.objects.remove(NamedObjectList.makeLookupKey(namedObject)));
    }

    List<N> values() {
        ArrayList<N> all = new ArrayList<N>(this.objects.values());
        Collections.sort(all);
        return all;
    }

    private Optional<N> internalGet(List<String> key) {
        return Optional.ofNullable(this.objects.get(key));
    }
}

