/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.DatabaseSpecificOptions;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.utility.Identifiers;
import schemacrawler.utility.JavaSqlTypes;
import schemacrawler.utility.TableTypes;
import schemacrawler.utility.TypeMap;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

final class RetrieverConnection {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RetrieverConnection.class.getName());
    private final Connection connection;
    private final DatabaseMetaData metaData;
    private final DatabaseSpecificOptions databaseSpecificOptions;
    private final MetadataRetrievalStrategy tableRetrievalStrategy;
    private final MetadataRetrievalStrategy tableColumnRetrievalStrategy;
    private final MetadataRetrievalStrategy pkRetrievalStrategy;
    private final MetadataRetrievalStrategy indexRetrievalStrategy;
    private final MetadataRetrievalStrategy fkRetrievalStrategy;
    private final InformationSchemaViews informationSchemaViews;
    private final TableTypes tableTypes;
    private final JavaSqlTypes javaSqlTypes;

    RetrieverConnection(Connection connection, DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions) throws SQLException {
        try {
            DatabaseUtility.checkConnection(connection);
        }
        catch (SchemaCrawlerException e) {
            throw new SQLException("Bad database connection", e);
        }
        this.connection = connection;
        this.metaData = connection.getMetaData();
        Objects.requireNonNull(databaseSpecificOverrideOptions, "No database specific overrides provided");
        this.informationSchemaViews = databaseSpecificOverrideOptions.getInformationSchemaViews();
        this.databaseSpecificOptions = new DatabaseSpecificOptions(connection, databaseSpecificOverrideOptions);
        LOGGER.log(Level.CONFIG, new StringFormat("%s", this.databaseSpecificOptions));
        this.tableRetrievalStrategy = databaseSpecificOverrideOptions.getTableRetrievalStrategy();
        this.tableColumnRetrievalStrategy = databaseSpecificOverrideOptions.getTableColumnRetrievalStrategy();
        this.pkRetrievalStrategy = databaseSpecificOverrideOptions.getPrimaryKeyRetrievalStrategy();
        this.indexRetrievalStrategy = databaseSpecificOverrideOptions.getIndexRetrievalStrategy();
        this.fkRetrievalStrategy = databaseSpecificOverrideOptions.getForeignKeyRetrievalStrategy();
        this.tableTypes = new TableTypes(connection);
        LOGGER.log(Level.CONFIG, new StringFormat("Supported table types are <%s>", this.tableTypes));
        this.javaSqlTypes = new JavaSqlTypes();
    }

    public MetadataRetrievalStrategy getForeignKeyRetrievalStrategy() {
        return this.fkRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getIndexRetrievalStrategy() {
        return this.indexRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getPrimaryKeyRetrievalStrategy() {
        return this.pkRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getTableRetrievalStrategy() {
        return this.tableRetrievalStrategy;
    }

    Connection getConnection() {
        return this.connection;
    }

    Identifiers getIdentifiers() {
        return this.databaseSpecificOptions.getIdentifiers();
    }

    InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    JavaSqlTypes getJavaSqlTypes() {
        return this.javaSqlTypes;
    }

    DatabaseMetaData getMetaData() {
        return this.metaData;
    }

    MetadataRetrievalStrategy getTableColumnRetrievalStrategy() {
        return this.tableColumnRetrievalStrategy;
    }

    TableTypes getTableTypes() {
        return this.tableTypes;
    }

    TypeMap getTypeMap() {
        return this.databaseSpecificOptions.getTypeMap();
    }

    boolean isSupportsCatalogs() {
        return this.databaseSpecificOptions.isSupportsCatalogs();
    }

    boolean isSupportsSchemas() {
        return this.databaseSpecificOptions.isSupportsSchemas();
    }
}

