/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableFunction;
import schemacrawler.crawl.MutableFunctionColumn;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableProcedureColumn;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.FunctionColumnType;
import schemacrawler.schema.FunctionReturnType;
import schemacrawler.schema.ProcedureColumnType;
import schemacrawler.schema.ProcedureReturnType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class RoutineRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RoutineRetriever.class.getName());

    RoutineRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveFunctionColumns(MutableFunction function, InclusionRule columnInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableFunctionColumn> columnFilter = new InclusionRuleFilter<MutableFunctionColumn>(columnInclusionRule, true);
        if (columnFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving function columns, since this was not requested");
            return;
        }
        int ordinalNumber = 0;
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getFunctionColumns(function.getSchema().getCatalogName(), function.getSchema().getName(), function.getName(), null));){
            while (results.next()) {
                String columnCatalogName = this.normalizeCatalogName(results.getString("FUNCTION_CAT"));
                String schemaName = this.normalizeSchemaName(results.getString("FUNCTION_SCHEM"));
                String functionName = results.getString("FUNCTION_NAME");
                String columnName = results.getString("COLUMN_NAME");
                String specificName = results.getString("SPECIFIC_NAME");
                MutableFunctionColumn column = new MutableFunctionColumn(function, columnName);
                if (!columnFilter.test(column) || !function.getName().equals(functionName) || !this.belongsToSchema(function, columnCatalogName, schemaName) || !Utility.isBlank(specificName) && !specificName.equals(function.getSpecificName())) continue;
                LOGGER.log(Level.FINE, new StringFormat("Retrieving function column: %s.%s", function.getFullName(), columnName));
                FunctionColumnType columnType = results.getEnumFromShortId("COLUMN_TYPE", FunctionColumnType.unknown);
                int dataType = results.getInt("DATA_TYPE", 0);
                String typeName = results.getString("TYPE_NAME");
                int length = results.getInt("LENGTH", 0);
                int precision = results.getInt("PRECISION", 0);
                boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
                String remarks = results.getString("REMARKS");
                column.setOrdinalPosition(ordinalNumber++);
                column.setFunctionColumnType(columnType);
                column.setColumnDataType(this.lookupOrCreateColumnDataType(function.getSchema(), dataType, typeName));
                column.setSize(length);
                column.setPrecision(precision);
                column.setNullable(isNullable);
                column.setRemarks(remarks);
                column.addAttributes(results.getAttributes());
                function.addColumn(column);
            }
        }
        catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
            this.logSQLFeatureNotSupported(new StringFormat("Could not retrieve columns for function %s", function), e);
        }
        catch (SQLException e) {
            this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve columns for function %s", function), e);
        }
    }

    void retrieveFunctions(Schema schema, InclusionRule routineInclusionRule) throws SQLException {
        Objects.requireNonNull(schema, "No schema provided");
        InclusionRuleFilter<MutableFunction> functionFilter = new InclusionRuleFilter<MutableFunction>(routineInclusionRule, false);
        if (functionFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving functions, since this was not requested");
            return;
        }
        Optional<SchemaReference> schemaOptional = this.catalog.lookupSchema(schema.getFullName());
        if (!schemaOptional.isPresent()) {
            LOGGER.log(Level.INFO, new StringFormat("Cannot locate schema, so not retrieving functions for schema: %s", schema));
            return;
        }
        LOGGER.log(Level.INFO, new StringFormat("Retrieving functions for schema: %s", schema));
        String catalogName = schema.getCatalogName();
        String schemaName = schema.getName();
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getFunctions(catalogName, schemaName, "%"));){
            while (results.next()) {
                String functionName = results.getString("FUNCTION_NAME");
                LOGGER.log(Level.FINE, new StringFormat("Retrieving function: %s.%s", schema, functionName));
                if (Utility.isBlank(functionName)) continue;
                FunctionReturnType functionType = results.getEnumFromShortId("FUNCTION_TYPE", FunctionReturnType.unknown);
                String remarks = results.getString("REMARKS");
                String specificName = results.getString("SPECIFIC_NAME");
                MutableFunction function = new MutableFunction(schema, functionName);
                if (!functionFilter.test(function)) continue;
                function.setReturnType(functionType);
                function.setSpecificName(specificName);
                function.setRemarks(remarks);
                function.addAttributes(results.getAttributes());
                this.catalog.addRoutine(function);
            }
        }
        catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
            this.logSQLFeatureNotSupported(new StringFormat("Could not retrieve functions", new Object[0]), e);
        }
        catch (SQLException e) {
            this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve functions", new Object[0]), e);
        }
    }

    void retrieveProcedureColumns(MutableProcedure procedure, InclusionRule columnInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableProcedureColumn> columnFilter = new InclusionRuleFilter<MutableProcedureColumn>(columnInclusionRule, true);
        if (columnFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving procedure columns, since this was not requested");
            return;
        }
        int ordinalNumber = 0;
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getProcedureColumns(procedure.getSchema().getCatalogName(), procedure.getSchema().getName(), procedure.getName(), null));){
            while (results.next()) {
                String columnCatalogName = this.normalizeCatalogName(results.getString("PROCEDURE_CAT"));
                String schemaName = this.normalizeSchemaName(results.getString("PROCEDURE_SCHEM"));
                String procedureName = results.getString("PROCEDURE_NAME");
                String columnName = results.getString("COLUMN_NAME");
                String specificName = results.getString("SPECIFIC_NAME");
                MutableProcedureColumn column = new MutableProcedureColumn(procedure, columnName);
                if (!columnFilter.test(column) || !procedure.getName().equals(procedureName) || !this.belongsToSchema(procedure, columnCatalogName, schemaName) || !Utility.isBlank(specificName) && !specificName.equals(procedure.getSpecificName())) continue;
                LOGGER.log(Level.FINE, new StringFormat("Retrieving procedure column: %s.%s", procedure.getFullName(), columnName));
                ProcedureColumnType columnType = results.getEnumFromShortId("COLUMN_TYPE", ProcedureColumnType.unknown);
                int dataType = results.getInt("DATA_TYPE", 0);
                String typeName = results.getString("TYPE_NAME");
                int length = results.getInt("LENGTH", 0);
                int precision = results.getInt("PRECISION", 0);
                boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
                String remarks = results.getString("REMARKS");
                column.setOrdinalPosition(ordinalNumber++);
                column.setProcedureColumnType(columnType);
                column.setColumnDataType(this.lookupOrCreateColumnDataType(procedure.getSchema(), dataType, typeName));
                column.setSize(length);
                column.setPrecision(precision);
                column.setNullable(isNullable);
                column.setRemarks(remarks);
                column.addAttributes(results.getAttributes());
                procedure.addColumn(column);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve columns for procedure " + procedure, e);
        }
    }

    void retrieveProcedures(Schema schema, InclusionRule routineInclusionRule) throws SQLException {
        Objects.requireNonNull(schema, "No schema provided");
        InclusionRuleFilter<MutableProcedure> procedureFilter = new InclusionRuleFilter<MutableProcedure>(routineInclusionRule, false);
        if (procedureFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving procedures, since this was not requested");
            return;
        }
        Optional<SchemaReference> schemaOptional = this.catalog.lookupSchema(schema.getFullName());
        if (!schemaOptional.isPresent()) {
            LOGGER.log(Level.INFO, new StringFormat("Cannot locate schema, so not retrieving procedures for schema: %s", schema));
            return;
        }
        LOGGER.log(Level.INFO, new StringFormat("Retrieving procedures for schema: %s", schema));
        String catalogName = schema.getCatalogName();
        String schemaName = schema.getName();
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getProcedures(catalogName, schemaName, "%"));){
            results.setDescription("retrieveProcedures");
            while (results.next()) {
                String procedureName = results.getString("PROCEDURE_NAME");
                LOGGER.log(Level.FINE, new StringFormat("Retrieving procedure: %s.%s", schema, procedureName));
                if (Utility.isBlank(procedureName)) continue;
                ProcedureReturnType procedureType = results.getEnumFromShortId("PROCEDURE_TYPE", ProcedureReturnType.unknown);
                String remarks = results.getString("REMARKS");
                String specificName = results.getString("SPECIFIC_NAME");
                MutableProcedure procedure = new MutableProcedure(schema, procedureName);
                if (!procedureFilter.test(procedure)) continue;
                procedure.setReturnType(procedureType);
                procedure.setSpecificName(specificName);
                procedure.setRemarks(remarks);
                procedure.addAttributes(results.getAttributes());
                this.catalog.addRoutine(procedure);
            }
        }
    }
}

