/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableSynonym;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.utility.Query;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class SynonymRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SynonymRetriever.class.getName());

    SynonymRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveSynonymInformation(InclusionRule synonymInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableSynonym> synonymFilter = new InclusionRuleFilter<MutableSynonym>(synonymInclusionRule, false);
        if (synonymFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving synonyms, since this was not requested");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving synonyms");
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasSynonymsSql()) {
            LOGGER.log(Level.FINE, "Synonym definition SQL statement was not provided");
            return;
        }
        NamedObjectList<SchemaReference> schemas = this.getAllSchemas();
        Query synonymsDefinitionSql = informationSchemaViews.getSynonymsSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(synonymsDefinitionSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.normalizeCatalogName(results.getString("SYNONYM_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("SYNONYM_SCHEMA"));
                String synonymName = results.getString("SYNONYM_NAME");
                String referencedObjectCatalogName = results.getString("REFERENCED_OBJECT_CATALOG");
                String referencedObjectSchemaName = results.getString("REFERENCED_OBJECT_SCHEMA");
                String referencedObjectName = results.getString("REFERENCED_OBJECT_NAME");
                if (Utility.isBlank(referencedObjectName)) {
                    LOGGER.log(Level.FINE, new StringFormat("No reference for synonym <%s.%s.%s>", catalogName, schemaName, synonymName));
                    continue;
                }
                SchemaReference schema = new SchemaReference(catalogName, schemaName);
                SchemaReference referencedSchema = new SchemaReference(referencedObjectCatalogName, referencedObjectSchemaName);
                if (!schemas.contains(schema) && !schemas.contains(referencedSchema)) continue;
                Optional<MutableTable> referencedTable = this.lookupTable(referencedObjectCatalogName, referencedObjectSchemaName, referencedObjectName);
                Optional<MutableRoutine> referencedRoutine = this.lookupRoutine(referencedObjectCatalogName, referencedObjectSchemaName, referencedObjectName, referencedObjectName);
                DatabaseObject referencedObject = referencedTable.isPresent() ? (DatabaseObject)referencedTable.get() : (referencedRoutine.isPresent() ? (DatabaseObject)referencedRoutine.get() : new AbstractDatabaseObject(referencedSchema, referencedObjectName){
                    private static final long serialVersionUID = -2212843304418302122L;
                });
                MutableSynonym synonym = new MutableSynonym(schema, synonymName);
                synonym.setReferencedObject(referencedObject);
                synonym.addAttributes(results.getAttributes());
                if (!synonymFilter.test(synonym)) continue;
                this.catalog.addSynonym(synonym);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve synonyms", (Throwable)e);
        }
    }
}

