/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.function.Predicate;
import schemacrawler.filter.DatabaseObjectFilter;
import schemacrawler.filter.RoutineGrepFilter;
import schemacrawler.filter.RoutineTypesFilter;
import schemacrawler.filter.TableGrepFilter;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

public final class FilterFactory {
    public static Predicate<Routine> routineFilter(SchemaCrawlerOptions options) {
        Predicate<Routine> routineFilter = new RoutineTypesFilter(options).and(new DatabaseObjectFilter(options, options.getRoutineInclusionRule())).and(new RoutineGrepFilter(options));
        return routineFilter;
    }

    public static Predicate<Table> tableFilter(SchemaCrawlerOptions options) {
        Predicate<Table> tableFilter = new TableTypesFilter(options).and(new DatabaseObjectFilter(options, options.getTableInclusionRule())).and(new TableGrepFilter(options));
        return tableFilter;
    }

    private FilterFactory() {
    }
}

