/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.schemacrawler.Options;
import schemacrawler.utility.Identifiers;
import schemacrawler.utility.TypeMap;
import sf.util.Utility;

public class DatabaseSpecificOptions
implements Options {
    private static final long serialVersionUID = -3064713207381359649L;
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;
    private final Identifiers identifiers;
    private final TypeMap typeMap;

    public DatabaseSpecificOptions(Connection connection, DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions) throws SQLException {
        DatabaseMetaData metaData;
        Objects.requireNonNull(connection, "No connection provided");
        Objects.requireNonNull(databaseSpecificOverrideOptions, "No database specific override options provided");
        try {
            metaData = connection.getMetaData();
        }
        catch (SQLException e) {
            metaData = null;
        }
        String identifierQuoteString = this.lookupIdentifierQuoteString(metaData, databaseSpecificOverrideOptions);
        this.identifiers = Identifiers.identifiers().withConnectionIfPossible(connection).withIdentifierQuoteString(identifierQuoteString).build();
        this.supportsCatalogs = this.lookupSupportsCatalogs(metaData, databaseSpecificOverrideOptions);
        this.supportsSchemas = this.lookupSupportsSchemas(metaData, databaseSpecificOverrideOptions);
        this.typeMap = databaseSpecificOverrideOptions.hasOverrideForTypeMap() ? databaseSpecificOverrideOptions.getTypeMap() : new TypeMap(connection);
    }

    public String getIdentifierQuoteString() {
        return this.identifiers.getIdentifierQuoteString();
    }

    public Identifiers getIdentifiers() {
        return this.identifiers;
    }

    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    public boolean isSupportsCatalogs() {
        return this.supportsCatalogs;
    }

    public boolean isSupportsSchemas() {
        return this.supportsSchemas;
    }

    public String toString() {
        return "DatabaseSpecificOptions [supportsSchemas=" + this.supportsSchemas + ", supportsCatalogs=" + this.supportsCatalogs + ", identifierQuoteString=\"" + this.getIdentifierQuoteString() + "\"]";
    }

    private String lookupIdentifierQuoteString(DatabaseMetaData metaData, DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions) throws SQLException {
        String identifierQuoteString = "\"";
        if (databaseSpecificOverrideOptions != null && databaseSpecificOverrideOptions.hasOverrideForIdentifierQuoteString()) {
            identifierQuoteString = databaseSpecificOverrideOptions.getIdentifierQuoteString();
        } else if (metaData != null) {
            identifierQuoteString = metaData.getIdentifierQuoteString();
        }
        if (Utility.isBlank(identifierQuoteString)) {
            identifierQuoteString = "";
        }
        return identifierQuoteString;
    }

    private boolean lookupSupportsCatalogs(DatabaseMetaData metaData, DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions) throws SQLException {
        boolean supportsCatalogs = databaseSpecificOverrideOptions != null && databaseSpecificOverrideOptions.hasOverrideForSupportsCatalogs() ? databaseSpecificOverrideOptions.isSupportsCatalogs() : (metaData != null ? metaData.supportsCatalogsInTableDefinitions() : true);
        return supportsCatalogs;
    }

    private boolean lookupSupportsSchemas(DatabaseMetaData metaData, DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions) throws SQLException {
        boolean supportsSchemas = databaseSpecificOverrideOptions != null && databaseSpecificOverrideOptions.hasOverrideForSupportsSchemas() ? databaseSpecificOverrideOptions.isSupportsSchemas() : (metaData != null ? metaData.supportsSchemasInTableDefinitions() : true);
        return supportsSchemas;
    }
}

