/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Map;
import java.util.Optional;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptionsBuilder;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Options;
import schemacrawler.utility.TypeMap;
import sf.util.Utility;

public final class DatabaseSpecificOverrideOptions
implements Options {
    private static final long serialVersionUID = -5593417085363698921L;
    private final Optional<Boolean> supportsSchemas;
    private final Optional<Boolean> supportsCatalogs;
    private final MetadataRetrievalStrategy tableRetrievalStrategy;
    private final MetadataRetrievalStrategy tableColumnRetrievalStrategy;
    private final MetadataRetrievalStrategy pkRetrievalStrategy;
    private final MetadataRetrievalStrategy indexRetrievalStrategy;
    private final MetadataRetrievalStrategy fkRetrievalStrategy;
    private final String identifierQuoteString;
    private final InformationSchemaViews informationSchemaViews;
    private final TypeMap typeMap;

    public DatabaseSpecificOverrideOptions() {
        this(null);
    }

    protected DatabaseSpecificOverrideOptions(DatabaseSpecificOverrideOptionsBuilder builder) {
        DatabaseSpecificOverrideOptionsBuilder bldr = builder == null ? new DatabaseSpecificOverrideOptionsBuilder() : builder;
        this.supportsSchemas = bldr.getSupportsSchemas();
        this.supportsCatalogs = bldr.getSupportsCatalogs();
        this.tableRetrievalStrategy = bldr.getTableRetrievalStrategy();
        this.tableColumnRetrievalStrategy = bldr.getTableColumnRetrievalStrategy();
        this.pkRetrievalStrategy = bldr.getPrimaryKeyRetrievalStrategy();
        this.indexRetrievalStrategy = bldr.getIndexRetrievalStrategy();
        this.fkRetrievalStrategy = bldr.getForeignKeyRetrievalStrategy();
        this.identifierQuoteString = bldr.getIdentifierQuoteString();
        this.informationSchemaViews = bldr.getInformationSchemaViewsBuilder().toOptions();
        Map<String, Class<?>> bldrTypeMap = bldr.getTypeMap();
        this.typeMap = bldrTypeMap != null ? new TypeMap(bldrTypeMap) : null;
    }

    public MetadataRetrievalStrategy getForeignKeyRetrievalStrategy() {
        return this.fkRetrievalStrategy;
    }

    public String getIdentifierQuoteString() {
        if (!this.hasOverrideForIdentifierQuoteString()) {
            return "";
        }
        return this.identifierQuoteString;
    }

    public MetadataRetrievalStrategy getIndexRetrievalStrategy() {
        return this.indexRetrievalStrategy;
    }

    public InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    public MetadataRetrievalStrategy getPrimaryKeyRetrievalStrategy() {
        return this.pkRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getTableColumnRetrievalStrategy() {
        return this.tableColumnRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getTableRetrievalStrategy() {
        return this.tableRetrievalStrategy;
    }

    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    public boolean hasOverrideForIdentifierQuoteString() {
        return !Utility.isBlank(this.identifierQuoteString);
    }

    public boolean hasOverrideForSupportsCatalogs() {
        return this.supportsCatalogs.isPresent();
    }

    public boolean hasOverrideForSupportsSchemas() {
        return this.supportsSchemas.isPresent();
    }

    public boolean hasOverrideForTypeMap() {
        return this.typeMap != null;
    }

    public boolean isSupportsCatalogs() {
        return this.supportsCatalogs.orElse(true);
    }

    public boolean isSupportsSchemas() {
        return this.supportsSchemas.orElse(true);
    }
}

