/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.OptionsBuilder;

public class DatabaseSpecificOverrideOptionsBuilder
implements OptionsBuilder<DatabaseSpecificOverrideOptions> {
    private static final String SC_RETRIEVAL_TABLES = "schemacrawler.schema.retrieval.strategy.tables";
    private static final String SC_RETRIEVAL_TABLE_COLUMNS = "schemacrawler.schema.retrieval.strategy.tablecolumns";
    private static final String SC_RETRIEVAL_PRIMARY_KEYS = "schemacrawler.schema.retrieval.strategy.primarykeys";
    private static final String SC_RETRIEVAL_INDEXES = "schemacrawler.schema.retrieval.strategy.indexes";
    private static final String SC_RETRIEVAL_FOREIGN_KEYS = "schemacrawler.schema.retrieval.strategy.foreignkeys";
    private Optional<Boolean> supportsSchemas;
    private Optional<Boolean> supportsCatalogs;
    private MetadataRetrievalStrategy tableRetrievalStrategy;
    private MetadataRetrievalStrategy tableColumnRetrievalStrategy;
    private MetadataRetrievalStrategy pkRetrievalStrategy;
    private MetadataRetrievalStrategy indexRetrievalStrategy;
    private MetadataRetrievalStrategy fkRetrievalStrategy;
    private String identifierQuoteString = "";
    private Map<String, Class<?>> typeMap = null;
    private final InformationSchemaViewsBuilder informationSchemaViewsBuilder = new InformationSchemaViewsBuilder();

    public DatabaseSpecificOverrideOptionsBuilder() {
        this.supportsSchemas = Optional.empty();
        this.supportsCatalogs = Optional.empty();
        this.tableRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.tableColumnRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.pkRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.indexRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.fkRetrievalStrategy = MetadataRetrievalStrategy.metadata;
    }

    public DatabaseSpecificOverrideOptionsBuilder(Config map) {
        this();
        this.fromConfig(map);
    }

    public DatabaseSpecificOverrideOptionsBuilder doesNotSupportCatalogs() {
        this.supportsCatalogs = Optional.of(false);
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder doesNotSupportSchemas() {
        this.supportsSchemas = Optional.of(false);
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder fromConfig(Config config) {
        Config configProperties = config == null ? new Config() : new Config(config);
        this.informationSchemaViewsBuilder.fromConfig(configProperties);
        this.tableRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_TABLES, this.tableRetrievalStrategy);
        this.tableColumnRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_TABLE_COLUMNS, this.tableColumnRetrievalStrategy);
        this.pkRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_PRIMARY_KEYS, this.pkRetrievalStrategy);
        this.indexRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_INDEXES, this.indexRetrievalStrategy);
        this.fkRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_FOREIGN_KEYS, this.fkRetrievalStrategy);
        return this;
    }

    public MetadataRetrievalStrategy getForeignKeyRetrievalStrategy() {
        return this.fkRetrievalStrategy;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public MetadataRetrievalStrategy getIndexRetrievalStrategy() {
        return this.indexRetrievalStrategy;
    }

    public InformationSchemaViewsBuilder getInformationSchemaViewsBuilder() {
        return this.informationSchemaViewsBuilder;
    }

    public MetadataRetrievalStrategy getPrimaryKeyRetrievalStrategy() {
        return this.pkRetrievalStrategy;
    }

    public Optional<Boolean> getSupportsCatalogs() {
        return this.supportsCatalogs;
    }

    public Optional<Boolean> getSupportsSchemas() {
        return this.supportsSchemas;
    }

    public MetadataRetrievalStrategy getTableColumnRetrievalStrategy() {
        return this.tableColumnRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getTableRetrievalStrategy() {
        return this.tableRetrievalStrategy;
    }

    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    public DatabaseSpecificOverrideOptionsBuilder identifierQuoteString(String identifierQuoteString) {
        this.identifierQuoteString = identifierQuoteString;
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder supportsCatalogs() {
        this.supportsCatalogs = Optional.of(true);
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder supportsSchemas() {
        this.supportsSchemas = Optional.of(true);
        return this;
    }

    @Override
    public Config toConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatabaseSpecificOverrideOptions toOptions() {
        return new DatabaseSpecificOverrideOptions(this);
    }

    public DatabaseSpecificOverrideOptionsBuilder withForeignKeyRetrievalStrategy(MetadataRetrievalStrategy fkRetrievalStrategy) {
        this.fkRetrievalStrategy = fkRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : fkRetrievalStrategy;
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder withIndexRetrievalStrategy(MetadataRetrievalStrategy indexRetrievalStrategy) {
        this.indexRetrievalStrategy = indexRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : indexRetrievalStrategy;
        return this;
    }

    public InformationSchemaViewsBuilder withInformationSchemaViews() {
        return this.informationSchemaViewsBuilder;
    }

    public DatabaseSpecificOverrideOptionsBuilder withoutIdentifierQuoteString() {
        this.identifierQuoteString = null;
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder withoutSupportsCatalogs() {
        this.supportsCatalogs = Optional.empty();
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder withoutSupportsSchemas() {
        this.supportsSchemas = Optional.empty();
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder withPrimaryKeyRetrievalStrategy(MetadataRetrievalStrategy pkRetrievalStrategy) {
        this.pkRetrievalStrategy = pkRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : pkRetrievalStrategy;
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder withTableColumnRetrievalStrategy(MetadataRetrievalStrategy tableColumnRetrievalStrategy) {
        this.tableColumnRetrievalStrategy = tableColumnRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : tableColumnRetrievalStrategy;
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder withTableRetrievalStrategy(MetadataRetrievalStrategy tableRetrievalStrategy) {
        this.tableRetrievalStrategy = tableRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : tableRetrievalStrategy;
        return this;
    }

    public DatabaseSpecificOverrideOptionsBuilder withTypeMap(Map<String, Class<?>> typeMap) {
        this.typeMap = typeMap == null ? null : new HashMap(typeMap);
        return this;
    }
}

