/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import schemacrawler.schemacrawler.InformationSchemaKeyType;

public enum InformationSchemaKey {
    ADDITIONAL_COLUMN_ATTRIBUTES(InformationSchemaKeyType.ADDITIONAL_INFO),
    ADDITIONAL_TABLE_ATTRIBUTES(InformationSchemaKeyType.ADDITIONAL_INFO),
    CONSTRAINT_COLUMN_USAGE(InformationSchemaKeyType.INFORMATION_SCHEMA),
    EXT_FOREIGN_KEYS(InformationSchemaKeyType.METADATA_EXTENSION),
    EXT_HIDDEN_TABLE_COLUMNS(InformationSchemaKeyType.METADATA_EXTENSION),
    EXT_INDEXES(InformationSchemaKeyType.METADATA_EXTENSION),
    EXT_INDEX_COLUMNS(InformationSchemaKeyType.METADATA_EXTENSION),
    EXT_PRIMARY_KEYS(InformationSchemaKeyType.METADATA_EXTENSION),
    EXT_SYNONYMS(InformationSchemaKeyType.METADATA_EXTENSION),
    EXT_TABLES(InformationSchemaKeyType.METADATA_EXTENSION),
    EXT_TABLE_CONSTRAINTS(InformationSchemaKeyType.METADATA_EXTENSION),
    FOREIGN_KEYS(InformationSchemaKeyType.DATABASE_METADATA),
    INDEXES(InformationSchemaKeyType.DATABASE_METADATA),
    OVERRIDE_TYPE_INFO(InformationSchemaKeyType.DATABASE_METADATA),
    PRIMARY_KEYS(InformationSchemaKeyType.DATABASE_METADATA),
    ROUTINES(InformationSchemaKeyType.INFORMATION_SCHEMA),
    SCHEMATA(InformationSchemaKeyType.INFORMATION_SCHEMA),
    SEQUENCES(InformationSchemaKeyType.INFORMATION_SCHEMA),
    TABLES(InformationSchemaKeyType.DATABASE_METADATA),
    TABLE_COLUMNS(InformationSchemaKeyType.DATABASE_METADATA),
    TABLE_CONSTRAINTS(InformationSchemaKeyType.INFORMATION_SCHEMA),
    TRIGGERS(InformationSchemaKeyType.INFORMATION_SCHEMA),
    VIEWS(InformationSchemaKeyType.INFORMATION_SCHEMA);

    private final String lookupKey;
    private final InformationSchemaKeyType type;

    private InformationSchemaKey(InformationSchemaKeyType type) {
        this.type = type;
        this.lookupKey = String.format("select.%s.%s", type.name(), this.name());
    }

    public String getLookupKey() {
        return this.lookupKey;
    }

    public String getResource() {
        return this.name() + ".sql";
    }

    public InformationSchemaKeyType getType() {
        return this.type;
    }
}

