/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.ExcludeAll;
import schemacrawler.schemacrawler.IncludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import sf.util.ObjectToString;
import sf.util.Utility;

public final class SchemaCrawlerOptions
implements Options {
    private static final long serialVersionUID = -3557794862382066029L;
    private SchemaInfoLevel schemaInfoLevel = SchemaInfoLevelBuilder.standard();
    private String title = "";
    private InclusionRule schemaInclusionRule = new IncludeAll();
    private InclusionRule synonymInclusionRule = new ExcludeAll();
    private InclusionRule sequenceInclusionRule = new ExcludeAll();
    private Collection<String> tableTypes = SchemaCrawlerOptions.defaultTableTypes();
    private String tableNamePattern;
    private InclusionRule tableInclusionRule = new IncludeAll();
    private InclusionRule columnInclusionRule = new IncludeAll();
    private Collection<RoutineType> routineTypes = SchemaCrawlerOptions.allRoutineTypes();
    private InclusionRule routineInclusionRule = new ExcludeAll();
    private InclusionRule routineColumnInclusionRule = new ExcludeAll();
    private InclusionRule grepColumnInclusionRule;
    private InclusionRule grepRoutineColumnInclusionRule;
    private InclusionRule grepDefinitionInclusionRule;
    private boolean grepInvertMatch;
    private boolean grepOnlyMatching;
    private boolean hideEmptyTables;
    private int childTableFilterDepth;
    private int parentTableFilterDepth;

    private static Collection<RoutineType> allRoutineTypes() {
        return Arrays.asList(RoutineType.procedure, RoutineType.function);
    }

    private static Collection<String> defaultTableTypes() {
        return Arrays.asList("BASE TABLE", "TABLE", "VIEW");
    }

    public int getChildTableFilterDepth() {
        return this.childTableFilterDepth;
    }

    public InclusionRule getColumnInclusionRule() {
        return this.columnInclusionRule;
    }

    public InclusionRule getGrepColumnInclusionRule() {
        return this.grepColumnInclusionRule;
    }

    public InclusionRule getGrepDefinitionInclusionRule() {
        return this.grepDefinitionInclusionRule;
    }

    public InclusionRule getGrepRoutineColumnInclusionRule() {
        return this.grepRoutineColumnInclusionRule;
    }

    public int getParentTableFilterDepth() {
        return this.parentTableFilterDepth;
    }

    public InclusionRule getRoutineColumnInclusionRule() {
        return this.routineColumnInclusionRule;
    }

    public InclusionRule getRoutineInclusionRule() {
        return this.routineInclusionRule;
    }

    public Collection<RoutineType> getRoutineTypes() {
        return new HashSet<RoutineType>(this.routineTypes);
    }

    public InclusionRule getSchemaInclusionRule() {
        return this.schemaInclusionRule;
    }

    public SchemaInfoLevel getSchemaInfoLevel() {
        return this.schemaInfoLevel;
    }

    public InclusionRule getSequenceInclusionRule() {
        return this.sequenceInclusionRule;
    }

    public InclusionRule getSynonymInclusionRule() {
        return this.synonymInclusionRule;
    }

    public InclusionRule getTableInclusionRule() {
        return this.tableInclusionRule;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public Collection<String> getTableTypes() {
        if (this.tableTypes == null) {
            return null;
        }
        return new HashSet<String>(this.tableTypes);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isGrepColumns() {
        return this.grepColumnInclusionRule != null;
    }

    public boolean isGrepDefinitions() {
        return this.grepDefinitionInclusionRule != null;
    }

    public boolean isGrepInvertMatch() {
        return this.grepInvertMatch;
    }

    public boolean isGrepOnlyMatching() {
        return this.grepOnlyMatching;
    }

    public boolean isGrepRoutineColumns() {
        return this.grepRoutineColumnInclusionRule != null;
    }

    public boolean isHideEmptyTables() {
        return this.hideEmptyTables;
    }

    public void setChildTableFilterDepth(int childTableFilterDepth) {
        this.childTableFilterDepth = childTableFilterDepth;
    }

    public void setColumnInclusionRule(InclusionRule columnInclusionRule) {
        this.columnInclusionRule = Objects.requireNonNull(columnInclusionRule, "Cannot use null value in a setter");
    }

    public void setGrepColumnInclusionRule(InclusionRule grepColumnInclusionRule) {
        this.grepColumnInclusionRule = grepColumnInclusionRule;
    }

    public void setGrepDefinitionInclusionRule(InclusionRule grepDefinitionInclusionRule) {
        this.grepDefinitionInclusionRule = grepDefinitionInclusionRule;
    }

    public void setGrepInvertMatch(boolean grepInvertMatch) {
        this.grepInvertMatch = grepInvertMatch;
    }

    public void setGrepOnlyMatching(boolean grepOnlyMatching) {
        this.grepOnlyMatching = grepOnlyMatching;
    }

    public void setGrepRoutineColumnInclusionRule(InclusionRule grepRoutineColumnInclusionRule) {
        this.grepRoutineColumnInclusionRule = grepRoutineColumnInclusionRule;
    }

    public void setHideEmptyTables(boolean hideEmptyTables) {
        this.hideEmptyTables = hideEmptyTables;
    }

    public void setParentTableFilterDepth(int parentTableFilterDepth) {
        this.parentTableFilterDepth = parentTableFilterDepth;
    }

    public void setRoutineColumnInclusionRule(InclusionRule routineColumnInclusionRule) {
        this.routineColumnInclusionRule = Objects.requireNonNull(routineColumnInclusionRule, "Cannot use null value in a setter");
    }

    public void setRoutineInclusionRule(InclusionRule routineInclusionRule) {
        this.routineInclusionRule = Objects.requireNonNull(routineInclusionRule, "Cannot use null value in a setter");
    }

    public void setRoutineTypes(Collection<RoutineType> routineTypes) {
        this.routineTypes = routineTypes == null ? SchemaCrawlerOptions.allRoutineTypes() : (routineTypes.isEmpty() ? Collections.emptySet() : new HashSet<RoutineType>(routineTypes));
    }

    public void setSchemaInclusionRule(InclusionRule schemaInclusionRule) {
        this.schemaInclusionRule = Objects.requireNonNull(schemaInclusionRule, "Cannot use null value in a setter");
    }

    public void setSchemaInfoLevel(SchemaInfoLevel schemaInfoLevel) {
        this.schemaInfoLevel = Objects.requireNonNull(schemaInfoLevel, "No schema information level provided");
    }

    public void setSequenceInclusionRule(InclusionRule sequenceInclusionRule) {
        this.sequenceInclusionRule = Objects.requireNonNull(sequenceInclusionRule, "Cannot use null value in a setter");
    }

    public void setSynonymInclusionRule(InclusionRule synonymInclusionRule) {
        this.synonymInclusionRule = Objects.requireNonNull(synonymInclusionRule, "Cannot use null value in a setter");
    }

    public void setTableInclusionRule(InclusionRule tableInclusionRule) {
        this.tableInclusionRule = Objects.requireNonNull(tableInclusionRule, "Cannot use null value in a setter");
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setTableTypes(Collection<String> tableTypes) {
        this.tableTypes = tableTypes == null ? null : (tableTypes.isEmpty() ? Collections.emptySet() : new HashSet<String>(tableTypes));
    }

    public void setTitle(String title) {
        this.title = Utility.isBlank(title) ? "" : title;
    }

    public String toString() {
        return ObjectToString.toString(this);
    }
}

