/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.IncludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import sf.util.Utility;

public class SchemaCrawlerOptionsBuilder
implements OptionsBuilder<SchemaCrawlerOptions> {
    private static final String SC_SCHEMA_PATTERN_EXCLUDE = "schemacrawler.schema.pattern.exclude";
    private static final String SC_SCHEMA_PATTERN_INCLUDE = "schemacrawler.schema.pattern.include";
    private static final String SC_SYNONYM_PATTERN_EXCLUDE = "schemacrawler.synonym.pattern.exclude";
    private static final String SC_SYNONYM_PATTERN_INCLUDE = "schemacrawler.synonym.pattern.include";
    private static final String SC_SEQUENCE_PATTERN_EXCLUDE = "schemacrawler.sequence.pattern.exclude";
    private static final String SC_SEQUENCE_PATTERN_INCLUDE = "schemacrawler.sequence.pattern.include";
    private static final String SC_TABLE_PATTERN_EXCLUDE = "schemacrawler.table.pattern.exclude";
    private static final String SC_TABLE_PATTERN_INCLUDE = "schemacrawler.table.pattern.include";
    private static final String SC_COLUMN_PATTERN_EXCLUDE = "schemacrawler.column.pattern.exclude";
    private static final String SC_COLUMN_PATTERN_INCLUDE = "schemacrawler.column.pattern.include";
    private static final String SC_ROUTINE_PATTERN_EXCLUDE = "schemacrawler.routine.pattern.exclude";
    private static final String SC_ROUTINE_PATTERN_INCLUDE = "schemacrawler.routine.pattern.include";
    private static final String SC_ROUTINE_COLUMN_PATTERN_EXCLUDE = "schemacrawler.routine.inout.pattern.exclude";
    private static final String SC_ROUTINE_COLUMN_PATTERN_INCLUDE = "schemacrawler.routine.inout.pattern.include";
    private static final String SC_GREP_COLUMN_PATTERN_INCLUDE = "schemacrawler.grep.column.pattern.include";
    private static final String SC_GREP_COLUMN_PATTERN_EXCLUDE = "schemacrawler.grep.column.pattern.exclude";
    private static final String SC_GREP_ROUTINE_COLUMN_PATTERN_EXCLUDE = "schemacrawler.grep.routine.inout.pattern.exclude";
    private static final String SC_GREP_ROUTINE_COLUMN_PATTERN_INCLUDE = "schemacrawler.grep.routine.inout.pattern.include";
    private static final String SC_GREP_DEFINITION_PATTERN_EXCLUDE = "schemacrawler.grep.definition.pattern.exclude";
    private static final String SC_GREP_DEFINITION_PATTERN_INCLUDE = "schemacrawler.grep.definition.pattern.include";
    private final SchemaCrawlerOptions options;

    public SchemaCrawlerOptionsBuilder() {
        this(new SchemaCrawlerOptions());
    }

    public SchemaCrawlerOptionsBuilder(SchemaCrawlerOptions options) {
        this.options = options;
    }

    public SchemaCrawlerOptionsBuilder childTableFilterDepth(int childTableFilterDepth) {
        this.options.setChildTableFilterDepth(childTableFilterDepth);
        return this;
    }

    public SchemaCrawlerOptionsBuilder fromConfig(Config config) {
        Config configProperties = config == null ? new Config() : new Config(config);
        this.options.setSchemaInclusionRule(configProperties.getInclusionRule(SC_SCHEMA_PATTERN_INCLUDE, SC_SCHEMA_PATTERN_EXCLUDE));
        this.options.setSynonymInclusionRule(configProperties.getInclusionRuleDefaultExclude(SC_SYNONYM_PATTERN_INCLUDE, SC_SYNONYM_PATTERN_EXCLUDE));
        this.options.setSequenceInclusionRule(configProperties.getInclusionRuleDefaultExclude(SC_SEQUENCE_PATTERN_INCLUDE, SC_SEQUENCE_PATTERN_EXCLUDE));
        this.options.setTableInclusionRule(configProperties.getInclusionRule(SC_TABLE_PATTERN_INCLUDE, SC_TABLE_PATTERN_EXCLUDE));
        this.options.setColumnInclusionRule(configProperties.getInclusionRule(SC_COLUMN_PATTERN_INCLUDE, SC_COLUMN_PATTERN_EXCLUDE));
        this.options.setRoutineInclusionRule(configProperties.getInclusionRule(SC_ROUTINE_PATTERN_INCLUDE, SC_ROUTINE_PATTERN_EXCLUDE));
        this.options.setRoutineColumnInclusionRule(configProperties.getInclusionRule(SC_ROUTINE_COLUMN_PATTERN_INCLUDE, SC_ROUTINE_COLUMN_PATTERN_EXCLUDE));
        this.options.setGrepColumnInclusionRule(configProperties.getInclusionRuleOrNull(SC_GREP_COLUMN_PATTERN_INCLUDE, SC_GREP_COLUMN_PATTERN_EXCLUDE));
        this.options.setGrepRoutineColumnInclusionRule(configProperties.getInclusionRuleOrNull(SC_GREP_ROUTINE_COLUMN_PATTERN_INCLUDE, SC_GREP_ROUTINE_COLUMN_PATTERN_EXCLUDE));
        this.options.setGrepDefinitionInclusionRule(configProperties.getInclusionRuleOrNull(SC_GREP_DEFINITION_PATTERN_INCLUDE, SC_GREP_DEFINITION_PATTERN_EXCLUDE));
        return this;
    }

    public SchemaCrawlerOptionsBuilder grepOnlyMatching(boolean grepOnlyMatching) {
        this.options.setGrepOnlyMatching(grepOnlyMatching);
        return this;
    }

    public SchemaCrawlerOptionsBuilder hideEmptyTables() {
        this.options.setHideEmptyTables(true);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeColumns(InclusionRule columnInclusionRule) {
        this.options.setColumnInclusionRule(columnInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeGreppedColumns(InclusionRule grepColumnInclusionRule) {
        this.options.setGrepColumnInclusionRule(grepColumnInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeGreppedDefinitions(InclusionRule grepDefinitionInclusionRule) {
        this.options.setGrepDefinitionInclusionRule(grepDefinitionInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeGreppedRoutineColumns(InclusionRule grepRoutineColumnInclusionRule) {
        this.options.setGrepRoutineColumnInclusionRule(grepRoutineColumnInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeRoutineColumns(InclusionRule routineColumnInclusionRule) {
        this.options.setRoutineColumnInclusionRule(routineColumnInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeRoutines(InclusionRule routineInclusionRule) {
        this.options.setRoutineInclusionRule(routineInclusionRule);
        this.options.setRoutineColumnInclusionRule(new IncludeAll());
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeSchemas(InclusionRule schemaInclusionRule) {
        this.options.setSchemaInclusionRule(schemaInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeSequences(InclusionRule sequenceInclusionRule) {
        this.options.setSequenceInclusionRule(sequenceInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeSynonyms(InclusionRule synonymInclusionRule) {
        this.options.setSynonymInclusionRule(synonymInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeTables(InclusionRule tableInclusionRule) {
        this.options.setTableInclusionRule(tableInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder invertGrepMatch(boolean grepInvertMatch) {
        this.options.setGrepInvertMatch(grepInvertMatch);
        return this;
    }

    public SchemaCrawlerOptionsBuilder parentTableFilterDepth(int parentTableFilterDepth) {
        this.options.setParentTableFilterDepth(parentTableFilterDepth);
        return this;
    }

    public SchemaCrawlerOptionsBuilder routineTypes(Collection<RoutineType> routineTypes) {
        this.options.setRoutineTypes(routineTypes);
        return this;
    }

    public SchemaCrawlerOptionsBuilder routineTypes(String routineTypesString) {
        String[] routineTypeStrings;
        HashSet<RoutineType> routineTypes = new HashSet<RoutineType>();
        if (routineTypesString != null && (routineTypeStrings = routineTypesString.split(",")) != null && routineTypeStrings.length > 0) {
            for (String routineTypeString : routineTypeStrings) {
                RoutineType routineType = Utility.enumValue(routineTypeString.toLowerCase(Locale.ENGLISH), RoutineType.unknown);
                routineTypes.add(routineType);
            }
        }
        this.options.setRoutineTypes(routineTypes);
        return this;
    }

    public SchemaCrawlerOptionsBuilder tableNamePattern(String tableNamePattern) {
        this.options.setTableNamePattern(tableNamePattern);
        return this;
    }

    public SchemaCrawlerOptionsBuilder tableTypes(Collection<String> tableTypes) {
        this.options.setTableTypes(tableTypes);
        return this;
    }

    public SchemaCrawlerOptionsBuilder tableTypes(String tableTypesString) {
        HashSet<String> tableTypes;
        if (tableTypesString != null) {
            tableTypes = new HashSet<String>();
            String[] tableTypeStrings = tableTypesString.split(",");
            if (tableTypeStrings != null && tableTypeStrings.length > 0) {
                for (String tableTypeString : tableTypeStrings) {
                    tableTypes.add(tableTypeString.trim());
                }
            }
        } else {
            tableTypes = null;
        }
        this.options.setTableTypes(tableTypes);
        return this;
    }

    public SchemaCrawlerOptionsBuilder title(String title) {
        this.options.setTitle(title);
        return this;
    }

    @Override
    public Config toConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaCrawlerOptions toOptions() {
        return this.options;
    }

    public SchemaCrawlerOptionsBuilder withSchemaInfoLevel(SchemaInfoLevel schemaInfoLevel) {
        this.options.setSchemaInfoLevel(schemaInfoLevel);
        return this;
    }
}

