/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaCrawlerException;

public abstract class BaseOptionsParser<O extends Options> {
    protected final Config config;

    protected BaseOptionsParser(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    protected final void consumeOption(String primaryOptionName) {
        this.config.remove(primaryOptionName);
    }

    protected abstract O getOptions() throws SchemaCrawlerException;

    protected final void normalizeOptionName(String primaryOptionName, String ... alternateOptionName) {
        Objects.requireNonNull(primaryOptionName);
        ArrayList<String> optionNames = new ArrayList<String>();
        optionNames.add(primaryOptionName);
        if (alternateOptionName != null) {
            optionNames.addAll(Arrays.asList(alternateOptionName));
        }
        Collections.reverse(optionNames);
        String value = null;
        boolean foundValue = false;
        for (String optionName : optionNames) {
            if (this.config.hasValue(optionName)) {
                value = this.config.get(optionName);
                foundValue = true;
            }
            this.config.remove(optionName);
        }
        if (foundValue) {
            this.config.put(primaryOptionName, value);
        }
    }
}

