/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerCommandLineException;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;

public final class DatabaseServerTypeParser
extends BaseOptionsParser<DatabaseConnector> {
    private static final String URL = "url";
    private static final String SERVER = "server";

    public DatabaseServerTypeParser(Config config) {
        super(config);
    }

    @Override
    public DatabaseConnector getOptions() throws SchemaCrawlerException {
        DatabaseConnector dbConnector;
        DatabaseConnectorRegistry registry = new DatabaseConnectorRegistry();
        String serverType = this.config.getStringValue(SERVER, null);
        if (this.config.hasValue(SERVER) && !registry.hasDatabaseSystemIdentifier(serverType)) {
            throw new SchemaCrawlerCommandLineException(String.format("Unsupported server <%s> %nPlease provide a database connection URL on the command-line, %nand re-run SchemaCrawler without the -server argument", serverType));
        }
        if (serverType != null) {
            dbConnector = registry.lookupDatabaseConnector(serverType);
            this.consumeOption(SERVER);
        } else {
            String connectionUrl = this.config.getStringValue(URL, null);
            dbConnector = registry.lookupDatabaseConnectorFromUrl(connectionUrl);
        }
        return dbConnector;
    }
}

