/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.nio.file.Path;
import java.nio.file.Paths;
import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import sf.util.IOUtility;
import sf.util.Utility;

public final class OutputOptionsParser
extends BaseOptionsParser<OutputOptions> {
    private static final String OUTPUT_FILE = "outputfile";
    private static final String OUTPUT_FORMAT = "outputformat";
    final OutputOptions outputOptions;

    public OutputOptionsParser(Config config) {
        super(config);
        this.normalizeOptionName(OUTPUT_FORMAT, "fmt");
        this.normalizeOptionName(OUTPUT_FILE, "o");
        this.outputOptions = new OutputOptions(config);
    }

    @Override
    public OutputOptions getOptions() {
        String fileExtension;
        String outputFileName = this.config.getStringValue(OUTPUT_FILE, null);
        this.consumeOption(OUTPUT_FILE);
        if (!Utility.isBlank(outputFileName)) {
            Path outputFile = Paths.get(outputFileName, new String[0]).toAbsolutePath();
            this.outputOptions.setOutputFile(outputFile);
            fileExtension = IOUtility.getFileExtension(outputFile);
        } else {
            fileExtension = "";
        }
        String defaultOutputFormatValue = Utility.isBlank(fileExtension) ? TextOutputFormat.text.getFormat() : fileExtension;
        String outputFormatValue = this.config.getStringValue(OUTPUT_FORMAT, defaultOutputFormatValue);
        this.consumeOption(OUTPUT_FORMAT);
        this.outputOptions.setOutputFormatValue(outputFormatValue);
        return this.outputOptions;
    }
}

