/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.Iterator;
import java.util.Objects;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.CommandParser;
import schemacrawler.tools.commandline.DatabaseServerTypeParser;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import schemacrawler.tools.databaseconnector.DatabaseServerType;
import schemacrawler.tools.executable.CommandRegistry;
import sf.util.IOUtility;
import sf.util.Utility;

public final class SchemaCrawlerHelpCommandLine
implements CommandLine {
    private final String command;
    private final boolean showVersionOnly;
    private final String connectionHelpResource;
    private final DatabaseServerType dbServerType;

    private static String loadHelpText(String helpResource) {
        if (Utility.isBlank(helpResource) || SchemaCrawlerHelpCommandLine.class.getResource(helpResource) == null) {
            return "";
        }
        return IOUtility.readResourceFully(helpResource);
    }

    public SchemaCrawlerHelpCommandLine(Config argsMap, boolean showVersionOnly) throws SchemaCrawlerException {
        Objects.requireNonNull(argsMap, "No command-line arguments provided");
        DatabaseServerTypeParser dbServerTypeParser = new DatabaseServerTypeParser(argsMap);
        DatabaseConnector dbConnector = dbServerTypeParser.getOptions();
        this.connectionHelpResource = dbConnector.getConnectionHelpResource();
        this.dbServerType = dbConnector.getDatabaseServerType();
        this.showVersionOnly = showVersionOnly;
        String command = null;
        if (!argsMap.isEmpty()) {
            CommandParser parser = new CommandParser(argsMap);
            if (parser.hasOptions()) {
                command = parser.getOptions().toString();
            }
            if (Utility.isBlank(command)) {
                command = null;
            }
        }
        this.command = command;
    }

    @Override
    public void execute() throws SchemaCrawlerException {
        CommandRegistry commandRegistry = new CommandRegistry();
        if (this.dbServerType != null && !this.dbServerType.isUnknownDatabaseSystem()) {
            System.out.println("SchemaCrawler for " + this.dbServerType.getDatabaseSystemName());
        }
        System.out.println(SchemaCrawlerHelpCommandLine.loadHelpText("/help/SchemaCrawler.txt"));
        System.out.println();
        if (this.showVersionOnly) {
            System.exit(0);
        }
        if (Utility.isBlank(this.connectionHelpResource)) {
            DatabaseConnectorRegistry databaseConnectorRegistry = new DatabaseConnectorRegistry();
            System.out.println(SchemaCrawlerHelpCommandLine.loadHelpText("/help/Connections.txt"));
            System.out.println("Available servers are: ");
            Iterator<String> iterator = databaseConnectorRegistry.iterator();
            while (iterator.hasNext()) {
                String availableServer = iterator.next();
                System.out.println("  " + availableServer);
            }
            System.out.println();
        } else {
            System.out.println(SchemaCrawlerHelpCommandLine.loadHelpText(this.connectionHelpResource));
        }
        System.out.println(SchemaCrawlerHelpCommandLine.loadHelpText("/help/SchemaCrawlerOptions.txt"));
        System.out.println(SchemaCrawlerHelpCommandLine.loadHelpText("/help/Config.txt"));
        System.out.println(SchemaCrawlerHelpCommandLine.loadHelpText("/help/ApplicationOptions.txt"));
        if (!commandRegistry.hasCommand(this.command)) {
            System.out.println(SchemaCrawlerHelpCommandLine.loadHelpText("/help/Command.txt"));
            System.out.println("  Available commands are: ");
            for (String availableCommand : commandRegistry) {
                System.out.println("    " + availableCommand);
            }
            System.out.println();
        } else {
            String helpResource = commandRegistry.getHelpResource(this.command);
            System.out.println(SchemaCrawlerHelpCommandLine.loadHelpText(helpResource));
            String helpAdditionalText = commandRegistry.getHelpAdditionalText(this.command);
            System.out.println(helpAdditionalText);
        }
        System.exit(0);
    }

    public final String getCommand() {
        return this.command;
    }
}

