/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.util.Objects;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.BaseDatabaseConnectionOptions;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.DatabaseConfigConnectionOptions;
import schemacrawler.schemacrawler.DatabaseConnectionOptions;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptionsBuilder;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SingleUseUserCredentials;
import schemacrawler.schemacrawler.UserCredentials;
import schemacrawler.tools.databaseconnector.DatabaseServerType;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import sf.util.Utility;

public abstract class DatabaseConnector
implements Options {
    private static final long serialVersionUID = 6133330582637434099L;
    protected static final DatabaseConnector UNKNOWN = new DatabaseConnector(){
        private static final long serialVersionUID = 3057770737518232349L;
    };
    private final DatabaseServerType dbServerType;
    private final String connectionHelpResource;
    private final String configResource;
    private final String informationSchemaViewsResourceFolder;
    private final Pattern connectionUrlPattern;

    protected DatabaseConnector(DatabaseServerType dbServerType, String connectionHelpResource, String configResource, String informationSchemaViewsResourceFolder, String connectionUrlPrefix) {
        this.dbServerType = Objects.requireNonNull(dbServerType, "No database server type provided");
        if (Utility.isBlank(connectionHelpResource)) {
            throw new IllegalArgumentException("No connection help resource provided");
        }
        this.connectionHelpResource = connectionHelpResource;
        this.configResource = configResource;
        this.informationSchemaViewsResourceFolder = informationSchemaViewsResourceFolder;
        if (Utility.isBlank(connectionUrlPrefix)) {
            throw new IllegalArgumentException("No JDBC connection URL prefix provided");
        }
        this.connectionUrlPattern = Pattern.compile(connectionUrlPrefix);
    }

    private DatabaseConnector() {
        this.dbServerType = DatabaseServerType.UNKNOWN;
        this.connectionHelpResource = null;
        this.configResource = null;
        this.informationSchemaViewsResourceFolder = null;
        this.connectionUrlPattern = null;
    }

    public void checkDatabaseConnectionOptions() throws SchemaCrawlerException {
        this.newDatabaseConnectionOptions(new SingleUseUserCredentials(), null);
    }

    public final Config getConfig() {
        Config config = Config.loadResource(this.configResource);
        return config;
    }

    public String getConnectionHelpResource() {
        return this.connectionHelpResource;
    }

    public final Pattern getConnectionUrlPattern() {
        return this.connectionUrlPattern;
    }

    public DatabaseServerType getDatabaseServerType() {
        return this.dbServerType;
    }

    public DatabaseSpecificOverrideOptionsBuilder getDatabaseSpecificOverrideOptionsBuilder() {
        DatabaseSpecificOverrideOptionsBuilder databaseSpecificOverrideOptionsBuilder = new DatabaseSpecificOverrideOptionsBuilder();
        databaseSpecificOverrideOptionsBuilder.withInformationSchemaViews().fromResourceFolder(this.informationSchemaViewsResourceFolder);
        return databaseSpecificOverrideOptionsBuilder;
    }

    public boolean isUnknownDatabaseSystem() {
        return this.dbServerType.isUnknownDatabaseSystem();
    }

    public ConnectionOptions newDatabaseConnectionOptions(UserCredentials userCredentials, Config additionalConfig) throws SchemaCrawlerException {
        if (userCredentials == null) {
            throw new IllegalArgumentException("No database connection user credentials provided");
        }
        Config config = this.getConfig();
        if (additionalConfig != null) {
            config.putAll(additionalConfig);
            additionalConfig.remove("user");
            additionalConfig.remove("password");
        }
        BaseDatabaseConnectionOptions connectionOptions = this.dbServerType.isUnknownDatabaseSystem() || config.hasValue("url") ? new DatabaseConnectionOptions(userCredentials, config) : new DatabaseConfigConnectionOptions(userCredentials, config);
        return connectionOptions;
    }

    public Executable newExecutable(String command) throws SchemaCrawlerException {
        return new SchemaCrawlerExecutable(command);
    }
}

