/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.DatabaseSpecificOptions;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.StagedExecutable;
import sf.util.ObjectToString;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public abstract class BaseStagedExecutable
extends BaseExecutable
implements StagedExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(BaseStagedExecutable.class.getName());

    protected BaseStagedExecutable(String command) {
        super(command);
    }

    @Override
    public final void execute(Connection connection, DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions) throws Exception {
        Objects.requireNonNull(connection, "No connection provided");
        Objects.requireNonNull(databaseSpecificOverrideOptions, "No database specific overrides provided");
        this.databaseSpecificOptions = new DatabaseSpecificOptions(connection, databaseSpecificOverrideOptions);
        LOGGER.log(Level.INFO, new StringFormat("Executing SchemaCrawler command <%s>", this.getCommand()));
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, String.format("Executable: %s", this.getClass().getName()));
            LOGGER.log(Level.CONFIG, ObjectToString.toString(this.schemaCrawlerOptions));
            LOGGER.log(Level.CONFIG, ObjectToString.toString(this.outputOptions));
            LOGGER.log(Level.CONFIG, this.databaseSpecificOptions.toString());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, ObjectToString.toString(this.additionalConfiguration));
        }
        SchemaCrawler schemaCrawler = new SchemaCrawler(connection, databaseSpecificOverrideOptions);
        Catalog catalog = schemaCrawler.crawl(this.schemaCrawlerOptions);
        this.executeOn(catalog, connection);
    }
}

