/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.executable.OperationExecutableCommandProvider;
import schemacrawler.tools.executable.SchemaExecutableCommandProvider;
import schemacrawler.tools.integration.scripting.ScriptCommandProvider;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class CommandRegistry
implements Iterable<String> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(CommandRegistry.class.getName());
    private final Map<String, CommandProvider> commandRegistry = CommandRegistry.loadCommandRegistry();

    private static Map<String, CommandProvider> loadCommandRegistry() throws SchemaCrawlerException {
        ArrayList<CommandProvider> commandProviders = new ArrayList<CommandProvider>();
        for (SchemaTextDetailType schemaTextDetailType : SchemaTextDetailType.values()) {
            commandProviders.add(new SchemaExecutableCommandProvider(schemaTextDetailType));
        }
        for (Enum enum_ : Operation.values()) {
            commandProviders.add(new OperationExecutableCommandProvider((Operation)enum_));
        }
        commandProviders.add(new ScriptCommandProvider());
        try {
            ServiceLoader<CommandProvider> serviceLoader = ServiceLoader.load(CommandProvider.class);
            for (CommandProvider commandRegistryEntry : serviceLoader) {
                String string = commandRegistryEntry.getCommand();
                LOGGER.log(Level.FINER, new StringFormat("Loading executable, %s=%s", string, commandRegistryEntry.getClass().getName()));
                commandProviders.add(commandRegistryEntry);
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load extended command registry", e);
        }
        HashMap<String, CommandProvider> commandRegistry = new HashMap<String, CommandProvider>();
        for (CommandProvider commandProvider : commandProviders) {
            commandRegistry.put(commandProvider.getCommand(), commandProvider);
        }
        return commandRegistry;
    }

    public String getHelpAdditionalText(String command) {
        String helpAdditionalText = this.commandRegistry.containsKey(command) ? this.commandRegistry.get(command).getHelpAdditionalText() : null;
        return helpAdditionalText;
    }

    public String getHelpResource(String command) {
        String helpResource = this.commandRegistry.containsKey(command) ? this.commandRegistry.get(command).getHelpResource() : null;
        return helpResource;
    }

    public boolean hasCommand(String command) {
        return command != null && this.commandRegistry.containsKey(command);
    }

    @Override
    public Iterator<String> iterator() {
        return this.lookupAvailableCommands().iterator();
    }

    Executable configureNewExecutable(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) throws SchemaCrawlerException {
        CommandProvider commandProvider = this.commandRegistry.containsKey(command) ? this.commandRegistry.get(command) : new OperationExecutableCommandProvider(command);
        return commandProvider.configureNewExecutable(schemaCrawlerOptions, outputOptions);
    }

    private Collection<String> lookupAvailableCommands() {
        ArrayList<String> availableCommands = new ArrayList<String>(this.commandRegistry.keySet());
        Collections.sort(availableCommands);
        return availableCommands;
    }
}

