/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.logging.Level;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.executable.CommandDaisyChainExecutable;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.Commands;
import schemacrawler.tools.text.operation.OperationExecutable;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class SchemaCrawlerExecutable
extends BaseStagedExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawlerExecutable.class.getName());

    public SchemaCrawlerExecutable(String command) throws SchemaCrawlerException {
        super(command);
    }

    @Override
    public void executeOn(Catalog catalog, Connection connection) throws Exception {
        Commands commands = new Commands(this.getCommand());
        if (commands.isEmpty()) {
            throw new SchemaCrawlerException("No command specified");
        }
        BaseExecutable executable = null;
        CommandRegistry commandRegistry = new CommandRegistry();
        for (String command : commands) {
            boolean isConfiguredQuery;
            boolean isCommand = commandRegistry.hasCommand(command);
            boolean bl = isConfiguredQuery = this.additionalConfiguration != null && this.additionalConfiguration.containsKey(command);
            if (isCommand || isConfiguredQuery) continue;
            LOGGER.log(Level.INFO, new StringFormat("Executing as a query <%s>", this.getCommand()));
            executable = new OperationExecutable(this.getCommand());
            executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
            executable.setOutputOptions(this.outputOptions);
            break;
        }
        if (executable == null) {
            if (commands.hasMultipleCommands()) {
                LOGGER.log(Level.INFO, new StringFormat("Executing commands <%s> in sequence", commands));
                executable = new CommandDaisyChainExecutable(this.getCommand());
                executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
                executable.setOutputOptions(this.outputOptions);
            } else {
                executable = (BaseStagedExecutable)commandRegistry.configureNewExecutable(this.getCommand(), this.schemaCrawlerOptions, this.outputOptions);
                LOGGER.log(Level.INFO, new StringFormat("Executing command <%s> using executable <%s>", this.getCommand(), executable.getClass().getName()));
            }
        }
        executable.setDatabaseSpecificOptions(this.databaseSpecificOptions);
        executable.setAdditionalConfiguration(this.additionalConfiguration);
        executable.executeOn(catalog, connection);
    }
}

