/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.embeddedgraph;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.util.regex.Pattern;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.executable.CommandChainExecutable;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.options.TextOutputFormat;
import sf.util.IOUtility;

public class EmbeddedGraphExecutable
extends BaseStagedExecutable {
    private static Pattern svgInsertionPoint = Pattern.compile("<h2.*Tables.*h2>");
    private static Pattern svgStart = Pattern.compile("<svg.*");

    public EmbeddedGraphExecutable(String command) {
        super(command);
    }

    @Override
    public void executeOn(Catalog catalog, Connection connection) throws Exception {
        Path finalHtmlFile = IOUtility.createTempFilePath("schemacrawler", "html");
        Path baseHtmlFile = IOUtility.createTempFilePath("schemacrawler", "html");
        Path baseSvgFile = IOUtility.createTempFilePath("schemacrawler", "svg");
        CommandChainExecutable chain = new CommandChainExecutable();
        chain.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        chain.setDatabaseSpecificOptions(this.databaseSpecificOptions);
        chain.setAdditionalConfiguration(this.additionalConfiguration);
        chain.addNext(this.command, TextOutputFormat.html, baseHtmlFile);
        chain.addNext(this.command, GraphOutputFormat.svg, baseSvgFile);
        chain.executeOn(catalog, connection);
        try (BufferedWriter finalHtmlFileWriter = Files.newBufferedWriter(finalHtmlFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             BufferedReader baseHtmlFileReader = Files.newBufferedReader(baseHtmlFile, StandardCharsets.UTF_8);
             BufferedReader baseSvgFileReader = Files.newBufferedReader(baseSvgFile, StandardCharsets.UTF_8);){
            String line;
            while ((line = baseHtmlFileReader.readLine()) != null) {
                if (svgInsertionPoint.matcher(line).matches()) {
                    this.insertSvg(finalHtmlFileWriter, baseSvgFileReader);
                }
                finalHtmlFileWriter.append(line).append(System.lineSeparator());
            }
        }
        var8_8 = null;
        try (Writer writer = this.outputOptions.openNewOutputWriter();){
            IOUtility.copy(Files.newBufferedReader(finalHtmlFile, StandardCharsets.UTF_8), writer);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
    }

    private void insertSvg(BufferedWriter finalHtmlFileWriter, BufferedReader baseSvgFileReader) throws IOException {
        String line;
        finalHtmlFileWriter.append(System.lineSeparator());
        boolean skipLines = true;
        while ((line = baseSvgFileReader.readLine()) != null) {
            if (skipLines) {
                boolean bl = skipLines = !svgStart.matcher(line).matches();
            }
            if (skipLines) continue;
            finalHtmlFileWriter.append(line).append(System.lineSeparator());
        }
        finalHtmlFileWriter.append(System.lineSeparator());
    }
}

