/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.Writer;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.executable.BaseStagedExecutable;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class FreeMarkerRenderer
extends BaseStagedExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(FreeMarkerRenderer.class.getName());
    static final String COMMAND = "freemarker";

    public FreeMarkerRenderer() {
        super(COMMAND);
    }

    @Override
    public final void executeOn(Catalog catalog, Connection connection) throws Exception {
        String templateLocation = this.outputOptions.getOutputFormatValue();
        String templatePath = ".";
        File templateFilePath = new File(templateLocation);
        if (templateFilePath.exists()) {
            templatePath = templateFilePath.getAbsoluteFile().getParent();
            templateLocation = templateFilePath.getName();
        }
        System.setProperty("org.freemarker.loggerLibrary", String.valueOf(1));
        Logger.selectLoggerLibrary((int)1);
        LOGGER.log(Level.INFO, new StringFormat("Rendering using FreeMarker, version %s" + Configuration.getVersion().toString(), new Object[0]));
        Configuration cfg = new Configuration();
        ClassTemplateLoader ctl = new ClassTemplateLoader(FreeMarkerRenderer.class, "/");
        FileTemplateLoader ftl = new FileTemplateLoader(new File(templatePath));
        MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{ctl, ftl});
        cfg.setTemplateLoader((TemplateLoader)mtl);
        cfg.setEncoding(Locale.getDefault(), this.outputOptions.getInputCharset().name());
        cfg.setWhitespaceStripping(true);
        LOGGER.log(Level.CONFIG, new StringFormat("FreeMarker configuration properties <%s>", cfg));
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("catalog", catalog);
        context.put("identifiers", this.databaseSpecificOptions.getIdentifiers());
        try (Writer writer = this.outputOptions.openNewOutputWriter();){
            Template template = cfg.getTemplate(templateLocation);
            template.process(context, writer);
        }
    }
}

