/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.utility.ProcessExecutor;
import sf.util.FileContents;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public class GraphProcessExecutor
extends ProcessExecutor {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphProcessExecutor.class.getName());
    private final Path outputFile;
    private final Path dotFile;

    public GraphProcessExecutor(Path dotFile, Path outputFile, GraphOptions graphOptions, GraphOutputFormat graphOutputFormat) throws IOException {
        Objects.requireNonNull(dotFile, "No DOT file provided");
        Objects.requireNonNull(outputFile, "No graph output file provided");
        Objects.requireNonNull(graphOptions, "No graph options provided");
        Objects.requireNonNull(graphOutputFormat, "No graph output format provided");
        if (!IOUtility.isFileReadable(dotFile)) {
            throw new IOException("Cannot read DOT file, " + dotFile);
        }
        this.dotFile = dotFile;
        this.outputFile = outputFile.normalize().toAbsolutePath();
        if (!IOUtility.isFileWritable(this.outputFile)) {
            throw new IOException("Cannot write output file, " + this.outputFile);
        }
        this.createDiagramCommand(dotFile, outputFile, graphOptions, graphOutputFormat);
        LOGGER.log(Level.INFO, "Generating diagram using Graphviz:\n" + this.getCommand().toString());
    }

    @Override
    public Integer call() throws Exception {
        Integer exitCode = super.call();
        boolean isProcessInError = exitCode == null || exitCode != 0;
        LOGGER.log(Level.INFO, new FileContents(this.getProcessOutput()));
        FileContents processError = new FileContents(this.getProcessOutput());
        if (isProcessInError) {
            LOGGER.log(Level.SEVERE, new StringFormat("Process returned exit code %d%n%s", exitCode, processError));
            this.captureRecovery();
        } else {
            LOGGER.log(Level.WARNING, processError);
            LOGGER.log(Level.INFO, new StringFormat("Generated diagram <%s>", this.outputFile));
        }
        return exitCode;
    }

    public Path getDotFile() {
        return this.dotFile;
    }

    public Path getOutputFile() {
        return this.outputFile;
    }

    private void captureRecovery() throws SchemaCrawlerException {
        Path movedDotFile = this.outputFile.normalize().getParent().resolve(this.dotFile.getFileName());
        List<String> command = this.getCommand();
        command.remove(command.size() - 1);
        command.remove(command.size() - 1);
        command.add(this.outputFile.toString());
        command.add(movedDotFile.toString());
        String message = String.format("%s%nGenerate your diagram manually, using:%n%s", IOUtility.readResourceFully("/dot.error.txt"), String.join((CharSequence)" ", this.quoteCommandLine(command)));
        try {
            Files.move(this.dotFile, movedDotFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new SchemaCrawlerException(String.format("Could not move %s to %s", this.dotFile, movedDotFile), e);
        }
        LOGGER.log(Level.SEVERE, message);
        throw new SchemaCrawlerException(message);
    }

    private void createDiagramCommand(Path dotFile, Path outputFile, GraphOptions graphOptions, GraphOutputFormat graphOutputFormat) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("dot");
        if (graphOptions != null) {
            command.addAll(graphOptions.getGraphvizOpts());
        }
        command.add("-T");
        command.add(graphOutputFormat.getFormat());
        command.add("-o");
        command.add(outputFile.toString());
        command.add(dotFile.toString());
        this.setCommandLine(command);
    }
}

