/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.scripting;

import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerCommandLineException;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.executable.CommandChainExecutable;
import sf.util.IOUtility;
import sf.util.ObjectToString;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class ScriptExecutable
extends BaseStagedExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ScriptExecutable.class.getName());
    static final String COMMAND = "script";

    public ScriptExecutable() {
        super(COMMAND);
    }

    @Override
    public final void executeOn(Catalog catalog, Connection connection) throws Exception {
        String scriptFileName = this.outputOptions.getOutputFormatValue();
        if (Utility.isBlank(scriptFileName)) {
            throw new SchemaCrawlerCommandLineException("Please specify a script to execute");
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<ScriptEngineFactory> engineFactories = scriptEngineManager.getEngineFactories();
        ScriptEngineFactory scriptEngineFactory = null;
        ScriptEngineFactory javaScriptEngineFactory = null;
        for (ScriptEngineFactory engineFactory : engineFactories) {
            LOGGER.log(Level.FINER, new StringFormat("Evaluating script engine: %s %s (%s %s)", engineFactory.getEngineName(), engineFactory.getEngineVersion(), engineFactory.getLanguageName(), engineFactory.getLanguageVersion()));
            List<String> extensions = engineFactory.getExtensions();
            if (extensions.contains(IOUtility.getFileExtension(scriptFileName))) {
                scriptEngineFactory = engineFactory;
                break;
            }
            if (!engineFactory.getLanguageName().equalsIgnoreCase("JavaScript")) continue;
            javaScriptEngineFactory = engineFactory;
        }
        if (scriptEngineFactory == null) {
            scriptEngineFactory = javaScriptEngineFactory;
        }
        if (scriptEngineFactory == null) {
            throw new SchemaCrawlerException("Script engine not found");
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using script engine%n%s %s (%s %s)%nScript engine names: %s%nSupported file extensions: %s", scriptEngineFactory.getEngineName(), scriptEngineFactory.getEngineVersion(), scriptEngineFactory.getLanguageName(), scriptEngineFactory.getLanguageVersion(), ObjectToString.toString(scriptEngineFactory.getNames()), ObjectToString.toString(scriptEngineFactory.getExtensions())));
        }
        CommandChainExecutable chain = new CommandChainExecutable();
        chain.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        chain.setDatabaseSpecificOptions(this.databaseSpecificOptions);
        chain.setAdditionalConfiguration(this.additionalConfiguration);
        ScriptEngine scriptEngine = scriptEngineFactory.getScriptEngine();
        try (Reader reader = this.outputOptions.openNewInputReader();
             Writer writer = this.outputOptions.openNewOutputWriter();){
            scriptEngine.getContext().setWriter(writer);
            scriptEngine.put("catalog", catalog);
            scriptEngine.put("connection", connection);
            scriptEngine.put("chain", chain);
            if (scriptEngine instanceof Compilable) {
                CompiledScript script = ((Compilable)((Object)scriptEngine)).compile(reader);
                script.eval();
            } else {
                scriptEngine.eval(reader);
            }
        }
    }
}

