/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.iosource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.tools.iosource.InputReader;
import schemacrawler.tools.iosource.InputResource;
import sf.util.SchemaCrawlerLogger;

public class ReaderInputResource
implements InputResource {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ReaderInputResource.class.getName());
    private final Reader reader;

    public ReaderInputResource(Reader reader) {
        this.reader = Objects.requireNonNull(reader, "No reader provided");
    }

    @Override
    public Reader openNewInputReader(Charset charset) throws IOException {
        LOGGER.log(Level.INFO, "Input to provided reader");
        return new InputReader(this.getDescription(), new BufferedReader(this.reader), false);
    }

    public String toString() {
        return this.getDescription();
    }

    private String getDescription() {
        return "<reader>";
    }
}

