/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.text.utility.BinaryData;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;

final class DataResultSet {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(DataResultSet.class.getName());
    private final ResultSet rows;
    private final List<ResultsColumn> resultsColumns;
    private final boolean showLobs;

    public DataResultSet(ResultSet rows, boolean showLobs) throws SchemaCrawlerException {
        this.rows = Objects.requireNonNull(rows, "Cannot use null results");
        this.showLobs = showLobs;
        this.resultsColumns = SchemaCrawler.getResultColumns(rows).getColumns();
    }

    public String[] getColumnNames() {
        int columnCount = this.resultsColumns.size();
        String[] columnNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnNames[i] = this.resultsColumns.get(i).getName();
        }
        return columnNames;
    }

    public boolean next() throws SQLException {
        return this.rows.next();
    }

    public List<Object> row() throws SQLException {
        int columnCount = this.resultsColumns.size();
        ArrayList<Object> currentRow = new ArrayList<Object>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            currentRow.add(this.getColumnData(i));
        }
        return currentRow;
    }

    public int width() {
        return this.resultsColumns.size();
    }

    private Object getColumnData(int i) throws SQLException {
        Object columnData;
        int javaSqlType = this.resultsColumns.get(i).getColumnDataType().getJavaSqlType().getJavaSqlType();
        if (javaSqlType == 2005) {
            Clob clob = this.rows.getClob(i + 1);
            columnData = this.rows.wasNull() || clob == null ? null : this.readClob(clob);
        } else if (javaSqlType == 2011) {
            NClob nClob = this.rows.getNClob(i + 1);
            columnData = this.rows.wasNull() || nClob == null ? null : this.readClob(nClob);
        } else if (javaSqlType == 2004) {
            Blob blob = this.rows.getBlob(i + 1);
            columnData = this.rows.wasNull() || blob == null ? null : this.readBlob(blob);
        } else if (javaSqlType == -4) {
            InputStream stream = this.rows.getBinaryStream(i + 1);
            columnData = this.rows.wasNull() || stream == null ? null : this.readStream(stream);
        } else if (javaSqlType == -16 || javaSqlType == -1) {
            InputStream stream = this.rows.getAsciiStream(i + 1);
            columnData = this.rows.wasNull() || stream == null ? null : this.readStream(stream);
        } else {
            columnData = this.rows.getObject(i + 1);
            if (this.rows.wasNull()) {
                columnData = null;
            }
        }
        return columnData;
    }

    private BinaryData readBlob(Blob blob) {
        if (blob == null) {
            return null;
        }
        if (this.showLobs) {
            BinaryData lobData;
            InputStream in = null;
            try {
                try {
                    in = blob.getBinaryStream();
                }
                catch (SQLFeatureNotSupportedException e) {
                    LOGGER.log(Level.FINEST, "Could not read BLOB data", (Throwable)e);
                    in = null;
                }
                lobData = in != null ? new BinaryData(IOUtility.readFully(in)) : new BinaryData();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read BLOB data", (Throwable)e);
                lobData = new BinaryData();
            }
            return lobData;
        }
        return new BinaryData();
    }

    private BinaryData readClob(Clob clob) {
        if (clob == null) {
            return null;
        }
        if (this.showLobs) {
            BinaryData lobData;
            Reader rdr = null;
            try {
                try {
                    rdr = clob.getCharacterStream();
                }
                catch (SQLFeatureNotSupportedException e) {
                    LOGGER.log(Level.FINEST, "Could not read CLOB data, as character stream", (Throwable)e);
                    rdr = null;
                }
                if (rdr == null) {
                    try {
                        rdr = new InputStreamReader(clob.getAsciiStream());
                    }
                    catch (SQLFeatureNotSupportedException e) {
                        LOGGER.log(Level.FINEST, "Could not read CLOB data, as ASCII stream", (Throwable)e);
                        rdr = null;
                    }
                }
                if (rdr != null) {
                    String lobDataString = IOUtility.readFully(rdr);
                    if (lobDataString.isEmpty()) {
                        long clobLength = clob.length();
                        lobDataString = clob.getSubString(1L, (int)clobLength);
                    }
                    lobData = new BinaryData(lobDataString);
                } else {
                    lobData = new BinaryData();
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read CLOB data", (Throwable)e);
                lobData = new BinaryData();
            }
            return lobData;
        }
        return new BinaryData();
    }

    private BinaryData readStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        if (this.showLobs) {
            BufferedInputStream in = new BufferedInputStream(stream);
            BinaryData lobData = new BinaryData(IOUtility.readFully(in));
            return lobData;
        }
        return new BinaryData();
    }
}

