/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.text.base.BaseTextOptionsBuilder;
import schemacrawler.tools.text.schema.SchemaTextOptions;

public class SchemaTextOptionsBuilder
extends BaseTextOptionsBuilder<SchemaTextOptions> {
    private static final String SHOW_ORDINAL_NUMBERS = "schemacrawler.format.show_ordinal_numbers";
    private static final String SHOW_STANDARD_COLUMN_TYPE_NAMES = "schemacrawler.format.show_standard_column_type_names";
    private static final String SHOW_ROW_COUNTS = "schemacrawler.format.show_row_counts";
    private static final String HIDE_PRIMARY_KEY_NAMES = "schemacrawler.format.hide_primarykey_names";
    private static final String HIDE_FOREIGN_KEY_NAMES = "schemacrawler.format.hide_foreignkey_names";
    private static final String HIDE_INDEX_NAMES = "schemacrawler.format.hide_index_names";
    private static final String HIDE_CONSTRAINT_NAMES = "schemacrawler.format.hide_constraint_names";
    private static final String HIDE_TRIGGER_NAMES = "schemacrawler.format.hide_trigger_names";
    private static final String HIDE_ROUTINE_SPECIFIC_NAMES = "schemacrawler.format.hide_routine_specific_names";
    private static final String HIDE_REMARKS = "schemacrawler.format.hide_remarks";
    private static final String SHOW_WEAK_ASSOCIATIONS = "schemacrawler.format.show_weak_associations";
    private static final String SC_SORT_ALPHABETICALLY_TABLE_INDEXES = "schemacrawler.format.sort_alphabetically.table_indexes";
    private static final String SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS = "schemacrawler.format.sort_alphabetically.table_foreignkeys";

    public SchemaTextOptionsBuilder() {
        this(new SchemaTextOptions());
    }

    public SchemaTextOptionsBuilder(SchemaTextOptions options) {
        super(options);
    }

    @Override
    public SchemaTextOptionsBuilder fromConfig(Config map) {
        if (map == null) {
            return this;
        }
        super.fromConfig(map);
        Config config = new Config(map);
        ((SchemaTextOptions)this.options).setShowStandardColumnTypeNames(config.getBooleanValue(SHOW_STANDARD_COLUMN_TYPE_NAMES));
        ((SchemaTextOptions)this.options).setShowOrdinalNumbers(config.getBooleanValue(SHOW_ORDINAL_NUMBERS));
        ((SchemaTextOptions)this.options).setShowRowCounts(config.getBooleanValue(SHOW_ROW_COUNTS));
        ((SchemaTextOptions)this.options).setHideForeignKeyNames(config.getBooleanValue(HIDE_FOREIGN_KEY_NAMES));
        ((SchemaTextOptions)this.options).setHidePrimaryKeyNames(config.getBooleanValue(HIDE_PRIMARY_KEY_NAMES));
        ((SchemaTextOptions)this.options).setHideIndexNames(config.getBooleanValue(HIDE_INDEX_NAMES));
        ((SchemaTextOptions)this.options).setHideTriggerNames(config.getBooleanValue(HIDE_TRIGGER_NAMES));
        ((SchemaTextOptions)this.options).setHideRoutineSpecificNames(config.getBooleanValue(HIDE_ROUTINE_SPECIFIC_NAMES));
        ((SchemaTextOptions)this.options).setHideConstraintNames(config.getBooleanValue(HIDE_CONSTRAINT_NAMES));
        ((SchemaTextOptions)this.options).setHideRemarks(config.getBooleanValue(HIDE_REMARKS));
        ((SchemaTextOptions)this.options).setShowWeakAssociations(config.getBooleanValue(SHOW_WEAK_ASSOCIATIONS));
        ((SchemaTextOptions)this.options).setAlphabeticalSortForForeignKeys(config.getBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS));
        ((SchemaTextOptions)this.options).setAlphabeticalSortForIndexes(config.getBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_INDEXES));
        return this;
    }

    public SchemaTextOptionsBuilder noRemarks(boolean value) {
        ((SchemaTextOptions)this.options).setHideRemarks(value);
        return this;
    }

    public SchemaTextOptionsBuilder portableNames(boolean value) {
        ((SchemaTextOptions)this.options).setHideConstraintNames(value);
        ((SchemaTextOptions)this.options).setHideForeignKeyNames(value);
        ((SchemaTextOptions)this.options).setHideIndexNames(value);
        ((SchemaTextOptions)this.options).setHidePrimaryKeyNames(value);
        ((SchemaTextOptions)this.options).setHideTriggerNames(value);
        ((SchemaTextOptions)this.options).setHideRoutineSpecificNames(value);
        ((SchemaTextOptions)this.options).setShowUnqualifiedNames(value);
        return this;
    }

    public SchemaTextOptionsBuilder sortInOut(boolean value) {
        ((SchemaTextOptions)this.options).setAlphabeticalSortForRoutineColumns(value);
        return this;
    }

    @Override
    public Config toConfig() {
        Config config = super.toConfig();
        config.setBooleanValue(SHOW_STANDARD_COLUMN_TYPE_NAMES, ((SchemaTextOptions)this.options).isShowStandardColumnTypeNames());
        config.setBooleanValue(SHOW_ORDINAL_NUMBERS, ((SchemaTextOptions)this.options).isShowOrdinalNumbers());
        config.setBooleanValue(SHOW_ROW_COUNTS, ((SchemaTextOptions)this.options).isShowRowCounts());
        config.setBooleanValue(HIDE_FOREIGN_KEY_NAMES, ((SchemaTextOptions)this.options).isHideForeignKeyNames());
        config.setBooleanValue(HIDE_PRIMARY_KEY_NAMES, ((SchemaTextOptions)this.options).isHidePrimaryKeyNames());
        config.setBooleanValue(HIDE_INDEX_NAMES, ((SchemaTextOptions)this.options).isHideIndexNames());
        config.setBooleanValue(HIDE_TRIGGER_NAMES, ((SchemaTextOptions)this.options).isHideTriggerNames());
        config.setBooleanValue(HIDE_ROUTINE_SPECIFIC_NAMES, ((SchemaTextOptions)this.options).isHideRoutineSpecificNames());
        config.setBooleanValue(HIDE_CONSTRAINT_NAMES, ((SchemaTextOptions)this.options).isHideTableConstraintNames());
        config.setBooleanValue(HIDE_REMARKS, ((SchemaTextOptions)this.options).isHideRemarks());
        config.setBooleanValue(SHOW_WEAK_ASSOCIATIONS, ((SchemaTextOptions)this.options).isShowWeakAssociations());
        config.setBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS, ((SchemaTextOptions)this.options).isAlphabeticalSortForForeignKeys());
        config.setBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_INDEXES, ((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes());
        return config;
    }

    public SchemaTextOptionsBuilder weakAssociations(boolean value) {
        ((SchemaTextOptions)this.options).setShowWeakAssociations(value);
        return this;
    }
}

