/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SchemaCrawlerLogger {
    private static String loggerClass = SchemaCrawlerLogger.class.getName();
    private final Logger logger;

    public static SchemaCrawlerLogger getLogger(String name) {
        return new SchemaCrawlerLogger(Logger.getLogger(name));
    }

    private static void updateSource(LogRecord lr, int depth) {
        StackTraceElement[] steArray = Thread.currentThread().getStackTrace();
        if (steArray == null) {
            return;
        }
        for (int i = 1; i < steArray.length; ++i) {
            int index;
            StackTraceElement ste = steArray[i];
            if (loggerClass.equals(ste.getClassName()) || (index = i + depth) < 0 || index >= steArray.length) continue;
            StackTraceElement ste_i = steArray[index];
            lr.setSourceMethodName(ste_i.getMethodName());
            lr.setSourceClassName(ste_i.getClassName());
            break;
        }
    }

    private SchemaCrawlerLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public void log(Level level, int depth, String msg, Throwable thrown) {
        Objects.requireNonNull(level);
        if (!this.logger.isLoggable(level)) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        SchemaCrawlerLogger.updateSource(lr, depth);
        if (thrown != null) {
            lr.setThrown(thrown);
        }
        this.logger.log(lr);
    }

    public void log(Level level, String msg) {
        this.log(level, msg, null);
    }

    public void log(Level level, String msg, Throwable thrown) {
        this.log(level, 0, msg, thrown);
    }

    public void log(Level level, Supplier<String> msgSupplier) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        this.log(level, msgSupplier.get());
    }

    public void log(Level level, Supplier<String> msgSupplier, Throwable thrown) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        this.log(level, msgSupplier.get(), thrown);
    }
}

