/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import sf.util.IdentifiedEnum;

public final class Utility {
    public static void applyApplicationLogLevel(Level applicationLogLevel) {
        Level logLevel = applicationLogLevel == null ? Level.OFF : applicationLogLevel;
        LogManager logManager = LogManager.getLogManager();
        ArrayList<String> loggerNames = Collections.list(logManager.getLoggerNames());
        for (String loggerName : loggerNames) {
            Logger logger = logManager.getLogger(loggerName);
            if (logger == null) continue;
            logger.setLevel(null);
            for (Handler handler : logger.getHandlers()) {
                handler.setLevel(logLevel);
            }
        }
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(logLevel);
    }

    public static String commonPrefix(String string1, String string2) {
        int index = Utility.indexOfDifference(string1, string2);
        if (index == -1) {
            return null;
        }
        return string1.substring(0, index).toLowerCase();
    }

    public static boolean containsWhitespace(CharSequence text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String convertForComparison(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '_' && ch != '.') continue;
            builder.append(Character.toLowerCase(ch));
        }
        String textWithoutQuotes = builder.toString();
        return textWithoutQuotes;
    }

    public static <E extends Enum<E>> E enumValue(String value, E defaultValue) {
        Object enumValue;
        Objects.requireNonNull(defaultValue, "No default value provided");
        if (value == null) {
            enumValue = defaultValue;
        } else {
            try {
                Class<?> enumClass = defaultValue.getClass();
                if (enumClass.getEnclosingClass() != null) {
                    enumClass = enumClass.getEnclosingClass();
                }
                enumValue = Enum.valueOf(enumClass, value);
            }
            catch (Exception e) {
                enumValue = defaultValue;
            }
        }
        return enumValue;
    }

    public static <E extends Enum<E>> E enumValueFromId(int value, E defaultValue) {
        Objects.requireNonNull(defaultValue, "No default value provided");
        try {
            Class<?> enumClass = defaultValue.getClass();
            for (Enum enumValue : EnumSet.allOf(enumClass)) {
                if (((IdentifiedEnum)((Object)enumValue)).getId() != value) continue;
                return (E)enumValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static boolean isBlank(CharSequence text) {
        if (text == null || text.length() == 0) {
            return true;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isIntegral(CharSequence text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isDigit(ch) || ch == '+' || ch == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(String text) {
        return text != null && text.equals(text.toLowerCase());
    }

    public static String join(Collection<String> collection, String separator) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(1024);
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static String join(Map<String, String> map, String separator) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(1024);
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            buffer.append(entry.getKey()).append("=").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static String join(String[] collection, String separator) {
        return Utility.join(Arrays.asList(collection), separator);
    }

    private static int indexOfDifference(String string1, String string2) {
        int i;
        if (string1 == null || string2 == null) {
            return 0;
        }
        for (i = 0; i < string1.length() && i < string2.length() && string1.charAt(i) == string2.charAt(i); ++i) {
        }
        if (i < string2.length() || i < string1.length()) {
            return i;
        }
        return -1;
    }

    private Utility() {
    }
}

