/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.PartialDatabaseObject;

class DatabaseObjectReference<D extends DatabaseObject>
implements Serializable {
    private static final long serialVersionUID = 1748828818899660921L;
    private Reference<D> databaseObjectRef;
    private D partial;

    DatabaseObjectReference(D databaseObject, D partial) {
        this.databaseObjectRef = new SoftReference<D>(Objects.requireNonNull(databaseObject, "Database object not provided"));
        this.partial = (DatabaseObject)Objects.requireNonNull(partial, "Partial database object not provided");
        if (!(partial instanceof PartialDatabaseObject)) {
            throw new IllegalArgumentException("Partial database object not provided");
        }
        if (!partial.equals(databaseObject)) {
            throw new IllegalArgumentException("Inconsistent database object reference");
        }
    }

    public boolean equals(Object obj) {
        return this.partial.equals(obj);
    }

    public final D get() {
        DatabaseObject dereferencedDatabaseObject = this.databaseObjectRef != null ? (DatabaseObject)this.databaseObjectRef.get() : null;
        if (dereferencedDatabaseObject == null) {
            return this.partial;
        }
        return (D)dereferencedDatabaseObject;
    }

    public int hashCode() {
        return this.partial.hashCode();
    }

    public boolean isPartialDatabaseObjectReference() {
        return this.get() instanceof PartialDatabaseObject;
    }

    public String toString() {
        return this.partial.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in != null) {
            this.partial = (DatabaseObject)in.readObject();
            this.databaseObjectRef = new WeakReference<Object>(in.readObject());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (out != null) {
            out.writeObject(this.partial);
            out.writeObject(this.databaseObjectRef.get());
        }
    }
}

