/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.Column;
import schemacrawler.schema.IndexColumnSortSequence;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.utility.Query;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class IndexRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(IndexRetriever.class.getName());

    IndexRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveIndexes(NamedObjectList<MutableTable> allTables) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        MetadataRetrievalStrategy indexRetrievalStrategy = this.getRetrieverConnection().getIndexRetrievalStrategy();
        switch (indexRetrievalStrategy) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving indexes, using fast data dictionary retrieval");
                this.retrieveIndexesFromDataDictionary(allTables);
                break;
            }
            case metadata_all: {
                LOGGER.log(Level.INFO, "Retrieving indexes, using fast meta-data retrieval");
                this.retrieveIndexesFromMetadataForAllTables(allTables);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving indexes");
                this.retrieveIndexesFromMetadata(allTables);
                break;
            }
        }
    }

    void retrievePrimaryKeys(NamedObjectList<MutableTable> allTables) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        MetadataRetrievalStrategy pkRetrievalStrategy = this.getRetrieverConnection().getPrimaryKeyRetrievalStrategy();
        switch (pkRetrievalStrategy) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving primary keys, using fast data dictionary retrieval");
                this.retrievePrimaryKeysFromDataDictionary(allTables);
                break;
            }
            case metadata_all: {
                LOGGER.log(Level.INFO, "Retrieving primary keys, using fast meta-data retrieval");
                this.retrievePrimaryKeysFromMetadataForAllTables(allTables);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving primary keys");
                this.retrievePrimaryKeysFromMetadata(allTables);
                break;
            }
        }
    }

    private void createIndexes(MutableTable table, MetadataResultSet results) throws SQLException {
        while (results.next()) {
            this.createIndexForTable(table, results);
        }
    }

    private void createIndexForTable(MutableTable table, MetadataResultSet results) {
        MutableIndex index;
        Optional<MutableIndex> indexOptional;
        AbstractDependantObject column;
        String indexName = results.getString("INDEX_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving index <%s.%s>", table.getFullName(), indexName));
        String columnName = results.getString("COLUMN_NAME");
        if (Utility.isBlank(columnName)) {
            return;
        }
        LOGGER.log(Level.FINE, new StringFormat("Retrieving index column <%s.%s.%s>", table.getFullName(), indexName, columnName));
        boolean uniqueIndex = !results.getBoolean("NON_UNIQUE");
        IndexType type = results.getEnumFromId("TYPE", IndexType.unknown);
        int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
        IndexColumnSortSequence sortSequence = IndexColumnSortSequence.valueOfFromCode(results.getString("ASC_OR_DESC"));
        int cardinality = results.getInt("CARDINALITY", 0);
        int pages = results.getInt("PAGES", 0);
        Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
        if (columnOptional.isPresent()) {
            MutableColumn mutableColumn = columnOptional.get();
            mutableColumn.markAsPartOfIndex();
            if (uniqueIndex) {
                mutableColumn.markAsPartOfUniqueIndex();
            }
            column = mutableColumn;
        } else {
            column = new ColumnPartial(table, columnName);
        }
        if (Utility.isBlank(indexName)) {
            indexName = String.format("SC_%s", Integer.toHexString(column.getFullName().hashCode()).toUpperCase());
        }
        if ((indexOptional = table.lookupIndex(indexName)).isPresent()) {
            index = indexOptional.get();
        } else {
            index = new MutableIndex(table, indexName);
            table.addIndex(index);
        }
        MutableIndexColumn indexColumn = new MutableIndexColumn(index, (Column)((Object)column));
        indexColumn.setIndexOrdinalPosition(ordinalPosition);
        indexColumn.setSortSequence(sortSequence);
        index.addColumn(indexColumn);
        index.setUnique(uniqueIndex);
        index.setIndexType(type);
        index.setCardinality(cardinality);
        index.setPages(pages);
        index.addAttributes(results.getAttributes());
    }

    private void createPrimaryKeyForTable(MutableTable table, MetadataResultSet results) {
        Optional<MutableColumn> columnOptional;
        String columnName = results.getString("COLUMN_NAME");
        String primaryKeyName = results.getString("PK_NAME");
        int keySequence = Integer.parseInt(results.getString("KEY_SEQ"));
        LOGGER.log(Level.FINE, new StringFormat("Retrieving primary column <%s.%s.%s>", table.getFullName(), primaryKeyName, columnName));
        MutablePrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey == null) {
            primaryKey = new MutablePrimaryKey(table, primaryKeyName);
            table.setPrimaryKeyAndReplaceIndex(primaryKey);
        }
        if ((columnOptional = table.lookupColumn(columnName)).isPresent()) {
            MutableColumn column = columnOptional.get();
            column.markAsPartOfPrimaryKey();
            MutableIndexColumn indexColumn = new MutableIndexColumn(primaryKey, column);
            indexColumn.setSortSequence(IndexColumnSortSequence.ascending);
            indexColumn.setIndexOrdinalPosition(keySequence);
            primaryKey.addColumn(indexColumn);
        }
    }

    private Optional<MutableTable> lookupTable(NamedObjectList<MutableTable> allTables, MetadataResultSet results) {
        String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
        String tableName = results.getString("TABLE_NAME");
        Optional<MutableTable> optionalTable = allTables.lookup(Arrays.asList(catalogName, schemaName, tableName));
        return optionalTable;
    }

    private void retrieveIndexesFromDataDictionary(NamedObjectList<MutableTable> allTables) throws SchemaCrawlerSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasIndexesSql()) {
            LOGGER.log(Level.FINE, "Extended indexes SQL statement was not provided");
            return;
        }
        Query indexesSql = informationSchemaViews.getIndexesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(indexesSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveIndexesFromDataDictionary");
            while (results.next()) {
                Optional<MutableTable> optionalTable = this.lookupTable(allTables, results);
                if (!optionalTable.isPresent()) continue;
                MutableTable table = optionalTable.get();
                this.createIndexForTable(table, results);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve indexes from SQL:\n" + indexesSql, e);
        }
    }

    private void retrieveIndexesFromMetadata(MutableTable table, boolean unique) throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getIndexInfo(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName(), unique, true));){
            this.createIndexes(table, results);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve indexes for table " + table, e);
        }
    }

    private void retrieveIndexesFromMetadata(NamedObjectList<MutableTable> allTables) throws SQLException {
        for (MutableTable table : allTables) {
            if (table instanceof View) continue;
            this.retrieveIndexesFromMetadata(table, false);
            this.retrieveIndexesFromMetadata(table, true);
        }
    }

    private void retrieveIndexesFromMetadataForAllTables(NamedObjectList<MutableTable> allTables) throws SQLException {
        this.retrieveIndexesFromMetadataForAllTables(allTables, false);
        this.retrieveIndexesFromMetadataForAllTables(allTables, true);
    }

    private void retrieveIndexesFromMetadataForAllTables(NamedObjectList<MutableTable> allTables, boolean unique) throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getIndexInfo(null, null, "%", unique, true));){
            while (results.next()) {
                Optional<MutableTable> optionalTable = this.lookupTable(allTables, results);
                if (!optionalTable.isPresent()) continue;
                MutableTable table = optionalTable.get();
                this.createIndexForTable(table, results);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve indexes for tables", e);
        }
    }

    private void retrievePrimaryKeysFromDataDictionary(NamedObjectList<MutableTable> allTables) throws SchemaCrawlerSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasPrimaryKeysSql()) {
            LOGGER.log(Level.FINE, "Extended primary keys SQL statement was not provided");
            return;
        }
        Query pkSql = informationSchemaViews.getPrimaryKeysSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(pkSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrievePrimaryKeysFromDataDictionary");
            while (results.next()) {
                Optional<MutableTable> optionalTable = this.lookupTable(allTables, results);
                if (!optionalTable.isPresent()) continue;
                MutableTable table = optionalTable.get();
                this.createPrimaryKeyForTable(table, results);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve primary keys from SQL:\n" + pkSql, e);
        }
    }

    private void retrievePrimaryKeysFromMetadata(NamedObjectList<MutableTable> allTables) throws SQLException {
        for (MutableTable table : allTables) {
            if (table instanceof View) continue;
            try {
                MetadataResultSet results = new MetadataResultSet(this.getMetaData().getPrimaryKeys(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName()));
                Throwable throwable = null;
                try {
                    while (results.next()) {
                        this.createPrimaryKeyForTable(table, results);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
            catch (SQLException e) {
                throw new SchemaCrawlerSQLException("Could not retrieve primary keys for table " + table, e);
            }
        }
    }

    private void retrievePrimaryKeysFromMetadataForAllTables(NamedObjectList<MutableTable> allTables) throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getPrimaryKeys(null, null, "%"));){
            while (results.next()) {
                Optional<MutableTable> optionalTable = this.lookupTable(allTables, results);
                if (!optionalTable.isPresent()) continue;
                MutableTable table = optionalTable.get();
                this.createPrimaryKeyForTable(table, results);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve primary keys for tables", e);
        }
    }
}

