/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableFunction;
import schemacrawler.crawl.MutableFunctionColumn;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableProcedureColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.Function;
import schemacrawler.schema.FunctionColumnType;
import schemacrawler.schema.FunctionReturnType;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureColumnType;
import schemacrawler.schema.ProcedureReturnType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class RoutineRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RoutineRetriever.class.getName());

    RoutineRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveFunctionColumns(MutableFunction function, InclusionRule columnInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableFunctionColumn> columnFilter = new InclusionRuleFilter<MutableFunctionColumn>(columnInclusionRule, true);
        if (columnFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving function columns, since this was not requested");
            return;
        }
        int ordinalNumber = 0;
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getFunctionColumns(function.getSchema().getCatalogName(), function.getSchema().getName(), function.getName(), null));){
            while (results.next()) {
                String columnCatalogName = this.normalizeCatalogName(results.getString("FUNCTION_CAT"));
                String schemaName = this.normalizeSchemaName(results.getString("FUNCTION_SCHEM"));
                String functionName = results.getString("FUNCTION_NAME");
                String columnName = results.getString("COLUMN_NAME");
                String specificName = results.getString("SPECIFIC_NAME");
                MutableFunctionColumn column = new MutableFunctionColumn(function, columnName);
                if (!columnFilter.test(column) || !function.getName().equals(functionName) || !this.belongsToSchema(function, columnCatalogName, schemaName) || !Utility.isBlank(specificName) && !specificName.equals(function.getSpecificName())) continue;
                LOGGER.log(Level.FINE, new StringFormat("Retrieving function column: %s.%s", function.getFullName(), columnName));
                FunctionColumnType columnType = results.getEnumFromShortId("COLUMN_TYPE", FunctionColumnType.unknown);
                int dataType = results.getInt("DATA_TYPE", 0);
                String typeName = results.getString("TYPE_NAME");
                int length = results.getInt("LENGTH", 0);
                int precision = results.getInt("PRECISION", 0);
                boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
                String remarks = results.getString("REMARKS");
                column.setOrdinalPosition(ordinalNumber++);
                column.setFunctionColumnType(columnType);
                column.setColumnDataType(this.lookupOrCreateColumnDataType(function.getSchema(), dataType, typeName));
                column.setSize(length);
                column.setPrecision(precision);
                column.setNullable(isNullable);
                column.setRemarks(remarks);
                column.addAttributes(results.getAttributes());
                function.addColumn(column);
            }
        }
        catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
            this.logSQLFeatureNotSupported(new StringFormat("Could not retrieve columns for function %s", function), e);
        }
        catch (SQLException e) {
            this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve columns for function %s", function), e);
        }
    }

    void retrieveFunctions(NamedObjectList<SchemaReference> schemas, InclusionRule routineInclusionRule) throws SQLException {
        Objects.requireNonNull(schemas, "No schemas provided");
        InclusionRuleFilter<Function> functionFilter = new InclusionRuleFilter<Function>(routineInclusionRule, false);
        if (functionFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving functions, since this was not requested");
            return;
        }
        MetadataRetrievalStrategy functionRetrievalStrategy = this.getRetrieverConnection().getFunctionRetrievalStrategy();
        switch (functionRetrievalStrategy) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving functions, using fast data dictionary retrieval");
                this.retrieveFunctionsFromDataDictionary(schemas, functionFilter);
                break;
            }
            case metadata_all: {
                LOGGER.log(Level.INFO, "Retrieving functions, using fast meta-data retrieval");
                this.retrieveFunctionsFromMetadataForAllFunctions(schemas, functionFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving functions");
                this.retrieveFunctionsFromMetadata(schemas, functionFilter);
                break;
            }
        }
    }

    void retrieveProcedureColumns(MutableProcedure procedure, InclusionRule columnInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableProcedureColumn> columnFilter = new InclusionRuleFilter<MutableProcedureColumn>(columnInclusionRule, true);
        if (columnFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving procedure columns, since this was not requested");
            return;
        }
        int ordinalNumber = 0;
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getProcedureColumns(procedure.getSchema().getCatalogName(), procedure.getSchema().getName(), procedure.getName(), null));){
            while (results.next()) {
                String columnCatalogName = this.normalizeCatalogName(results.getString("PROCEDURE_CAT"));
                String schemaName = this.normalizeSchemaName(results.getString("PROCEDURE_SCHEM"));
                String procedureName = results.getString("PROCEDURE_NAME");
                String columnName = results.getString("COLUMN_NAME");
                String specificName = results.getString("SPECIFIC_NAME");
                MutableProcedureColumn column = new MutableProcedureColumn(procedure, columnName);
                if (!columnFilter.test(column) || !procedure.getName().equals(procedureName) || !this.belongsToSchema(procedure, columnCatalogName, schemaName) || !Utility.isBlank(specificName) && !specificName.equals(procedure.getSpecificName())) continue;
                LOGGER.log(Level.FINE, new StringFormat("Retrieving procedure column: %s.%s", procedure.getFullName(), columnName));
                ProcedureColumnType columnType = results.getEnumFromShortId("COLUMN_TYPE", ProcedureColumnType.unknown);
                int dataType = results.getInt("DATA_TYPE", 0);
                String typeName = results.getString("TYPE_NAME");
                int length = results.getInt("LENGTH", 0);
                int precision = results.getInt("PRECISION", 0);
                boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
                String remarks = results.getString("REMARKS");
                column.setOrdinalPosition(ordinalNumber++);
                column.setProcedureColumnType(columnType);
                column.setColumnDataType(this.lookupOrCreateColumnDataType(procedure.getSchema(), dataType, typeName));
                column.setSize(length);
                column.setPrecision(precision);
                column.setNullable(isNullable);
                column.setRemarks(remarks);
                column.addAttributes(results.getAttributes());
                procedure.addColumn(column);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve columns for procedure " + procedure, e);
        }
    }

    void retrieveProcedures(NamedObjectList<SchemaReference> schemas, InclusionRule routineInclusionRule) throws SQLException {
        Objects.requireNonNull(schemas, "No schemas provided");
        InclusionRuleFilter<Procedure> procedureFilter = new InclusionRuleFilter<Procedure>(routineInclusionRule, false);
        if (procedureFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving procedures, since this was not requested");
            return;
        }
        MetadataRetrievalStrategy procedureRetrievalStrategy = this.getRetrieverConnection().getProcedureRetrievalStrategy();
        switch (procedureRetrievalStrategy) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving procedures, using fast data dictionary retrieval");
                this.retrieveProceduresFromDataDictionary(schemas, procedureFilter);
                break;
            }
            case metadata_all: {
                LOGGER.log(Level.INFO, "Retrieving procedures, using fast meta-data retrieval");
                this.retrieveProceduresFromMetadataForAllProcedures(schemas, procedureFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving procedures");
                this.retrieveProceduresFromMetadata(schemas, procedureFilter);
                break;
            }
        }
    }

    private void createFunction(MetadataResultSet results, NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Function> functionFilter) {
        String catalogName = this.normalizeCatalogName(results.getString("FUNCTION_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("FUNCTION_SCHEM"));
        String functionName = results.getString("FUNCTION_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving function <%s.%s.%s>", catalogName, schemaName, functionName));
        if (Utility.isBlank(functionName)) {
            return;
        }
        FunctionReturnType functionType = results.getEnumFromShortId("FUNCTION_TYPE", FunctionReturnType.unknown);
        String remarks = results.getString("REMARKS");
        String specificName = results.getString("SPECIFIC_NAME");
        Optional<SchemaReference> optionalSchema = schemas.lookup(Arrays.asList(catalogName, schemaName));
        if (!optionalSchema.isPresent()) {
            return;
        }
        Schema schema = optionalSchema.get();
        MutableFunction function = new MutableFunction(schema, functionName);
        if (functionFilter.test(function)) {
            function.setReturnType(functionType);
            function.setSpecificName(specificName);
            function.setRemarks(remarks);
            function.addAttributes(results.getAttributes());
            this.catalog.addRoutine(function);
        }
    }

    private void createProcedure(MetadataResultSet results, NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Procedure> procedureFilter) {
        String catalogName = this.normalizeCatalogName(results.getString("PROCEDURE_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("PROCEDURE_SCHEM"));
        String procedureName = results.getString("PROCEDURE_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving procedure <%s.%s.%s>", catalogName, schemaName, procedureName));
        if (Utility.isBlank(procedureName)) {
            return;
        }
        ProcedureReturnType procedureType = results.getEnumFromShortId("PROCEDURE_TYPE", ProcedureReturnType.unknown);
        String remarks = results.getString("REMARKS");
        String specificName = results.getString("SPECIFIC_NAME");
        Optional<SchemaReference> optionalSchema = schemas.lookup(Arrays.asList(catalogName, schemaName));
        if (!optionalSchema.isPresent()) {
            return;
        }
        Schema schema = optionalSchema.get();
        MutableProcedure procedure = new MutableProcedure(schema, procedureName);
        if (procedureFilter.test(procedure)) {
            procedure.setReturnType(procedureType);
            procedure.setSpecificName(specificName);
            procedure.setRemarks(remarks);
            procedure.addAttributes(results.getAttributes());
            this.catalog.addRoutine(procedure);
        }
    }

    private void retrieveFunctionsFromDataDictionary(NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Function> functionFilter) {
        LOGGER.log(Level.CONFIG, "Not retrieving functions, since retrieval from data dictionary is not supported");
    }

    private void retrieveFunctionsFromMetadata(NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Function> functionFilter) {
        for (Schema schema : schemas) {
            LOGGER.log(Level.INFO, new StringFormat("Retrieving functions for schema <%s>", schema));
            String catalogName = schema.getCatalogName();
            String schemaName = schema.getName();
            try {
                MetadataResultSet results = new MetadataResultSet(this.getMetaData().getFunctions(catalogName, schemaName, "%"));
                Throwable throwable = null;
                try {
                    results.setDescription("retrieveFunctions");
                    while (results.next()) {
                        this.createFunction(results, schemas, functionFilter);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
            catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
                this.logSQLFeatureNotSupported(new StringFormat("Could not retrieve functions", new Object[0]), e);
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve functions", new Object[0]), e);
            }
        }
    }

    private void retrieveFunctionsFromMetadataForAllFunctions(NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Function> functionFilter) throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getFunctions(null, null, "%"));){
            results.setDescription("retrieveFunctions");
            while (results.next()) {
                this.createFunction(results, schemas, functionFilter);
            }
        }
        catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
            this.logSQLFeatureNotSupported(new StringFormat("Could not retrieve functions", new Object[0]), e);
        }
        catch (SQLException e) {
            this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve functions", new Object[0]), e);
        }
    }

    private void retrieveProceduresFromDataDictionary(NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Procedure> procedureFilter) {
        LOGGER.log(Level.CONFIG, "Not retrieving procedures, since retrieval from the data dictionary is not supported");
    }

    private void retrieveProceduresFromMetadata(NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Procedure> procedureFilter) throws SQLException {
        for (Schema schema : schemas) {
            LOGGER.log(Level.INFO, new StringFormat("Retrieving procedures for schema <%s>", schema));
            String catalogName = schema.getCatalogName();
            String schemaName = schema.getName();
            MetadataResultSet results = new MetadataResultSet(this.getMetaData().getProcedures(catalogName, schemaName, "%"));
            Throwable throwable = null;
            try {
                results.setDescription("retrieveProcedures");
                while (results.next()) {
                    this.createProcedure(results, schemas, procedureFilter);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (results == null) continue;
                if (throwable != null) {
                    try {
                        results.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                results.close();
            }
        }
    }

    private void retrieveProceduresFromMetadataForAllProcedures(NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Procedure> procedureFilter) throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getProcedures(null, null, "%"));){
            results.setDescription("retrieveProcedures");
            while (results.next()) {
                this.createProcedure(results, schemas, procedureFilter);
            }
        }
    }
}

