/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.function.Predicate;
import java.util.logging.Level;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineColumn;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

class RoutineGrepFilter
implements Predicate<Routine> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RoutineGrepFilter.class.getName());
    private final boolean invertMatch;
    private final InclusionRule grepColumnInclusionRule;
    private final InclusionRule grepDefinitionInclusionRule;

    public RoutineGrepFilter(SchemaCrawlerOptions options) {
        this.invertMatch = options.isGrepInvertMatch();
        this.grepColumnInclusionRule = options.getGrepRoutineColumnInclusionRule();
        this.grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule();
    }

    @Override
    public boolean test(Routine routine) {
        boolean include;
        boolean checkIncludeForDefinitions;
        boolean checkIncludeForColumns = this.grepColumnInclusionRule != null;
        boolean bl = checkIncludeForDefinitions = this.grepDefinitionInclusionRule != null;
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        for (RoutineColumn<? extends Routine> routineColumn : routine.getColumns()) {
            if (checkIncludeForColumns && this.grepColumnInclusionRule.test(routineColumn.getFullName())) {
                includeForColumns = true;
                break;
            }
            if (!checkIncludeForDefinitions || !this.grepDefinitionInclusionRule.test(routineColumn.getRemarks())) continue;
            includeForDefinitions = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (this.grepDefinitionInclusionRule.test(routine.getRemarks())) {
                includeForDefinitions = true;
            }
            if (this.grepDefinitionInclusionRule.test(routine.getDefinition())) {
                includeForDefinitions = true;
            }
        }
        boolean bl2 = include = checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (this.invertMatch) {
            boolean bl3 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, new StringFormat("Excluding routine <%s>", routine));
        }
        return include;
    }
}

