/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.schemacrawler.UserCredentials;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.TemplatingUtility;
import sf.util.Utility;

abstract class BaseDatabaseConnectionOptions
implements ConnectionOptions {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(BaseDatabaseConnectionOptions.class.getName());
    private static final String URL = "url";
    protected final Map<String, String> connectionProperties;
    private final UserCredentials userCredentials;

    protected static final Map<String, String> connectionUrlToMap(String connectionUrl) {
        if (Utility.isBlank(connectionUrl)) {
            throw new NullPointerException("No database connection URL provided");
        }
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        connectionProperties.put(URL, connectionUrl);
        return connectionProperties;
    }

    protected BaseDatabaseConnectionOptions(UserCredentials userCredentials, Map<String, String> properties) {
        if (userCredentials == null) {
            throw new IllegalArgumentException("No user credentials provided");
        }
        this.userCredentials = userCredentials;
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("No connection properties provided");
        }
        this.connectionProperties = new HashMap<String, String>(properties);
        TemplatingUtility.substituteVariables(this.connectionProperties);
    }

    @Override
    public final Connection getConnection() throws SQLException {
        String user = this.userCredentials.getUser();
        String password = this.userCredentials.getPassword();
        return this.getConnection(user, password);
    }

    @Override
    public final Connection getConnection(String user, String password) throws SQLException {
        String connectionUrl;
        if (Utility.isBlank(user)) {
            LOGGER.log(Level.WARNING, "Database user is not provided");
        }
        if (Utility.isBlank(password)) {
            LOGGER.log(Level.WARNING, "Database password is not provided");
        }
        try {
            connectionUrl = this.getConnectionUrl();
            if (Utility.isBlank(connectionUrl)) {
                throw new IllegalArgumentException("No database connection URL provided");
            }
        }
        catch (Exception e) {
            String username = user != null ? String.format("user '%s'", user) : "unspecified user";
            throw new SQLException(String.format("Could not connect to database, for %s", username), e);
        }
        Properties jdbcConnectionProperties = this.createConnectionProperties(connectionUrl, user, password);
        try {
            LOGGER.log(Level.INFO, new StringFormat("Making connection to %s%nfor user '%s', with properties %s", connectionUrl, user, this.safeProperties(jdbcConnectionProperties)));
            Driver driver = this.getJdbcDriver(connectionUrl);
            Connection connection = driver.connect(connectionUrl, jdbcConnectionProperties);
            LOGGER.log(Level.INFO, new StringFormat("Opened database connection <%s>", connection));
            this.logConnection(connection);
            jdbcConnectionProperties.remove("password");
            return connection;
        }
        catch (SQLException e) {
            String username = user != null ? String.format("user '%s'", user) : "unspecified user";
            throw new SchemaCrawlerSQLException(String.format("Could not connect to %s, for %s, with properties %s", connectionUrl, username, this.safeProperties(jdbcConnectionProperties)), e);
        }
    }

    @Override
    public String getConnectionUrl() {
        String connectionUrl = this.connectionProperties.get(URL);
        Set<String> unmatchedVariables = TemplatingUtility.extractTemplateVariables(connectionUrl);
        if (!unmatchedVariables.isEmpty()) {
            throw new IllegalArgumentException(String.format("Insufficient parameters for database connection URL: missing %s", unmatchedVariables));
        }
        return connectionUrl;
    }

    @Override
    public final Driver getJdbcDriver() throws SQLException {
        return this.getJdbcDriver(this.getConnectionUrl());
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw this.newSQLFeatureNotSupportedException();
    }

    @Override
    public UserCredentials getUserCredentials() {
        return this.userCredentials;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw this.newSQLFeatureNotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (out != null) {
            throw this.newSQLFeatureNotSupportedException();
        }
    }

    public final String toString() {
        String jdbcDriverClass = "<unknown>";
        try {
            Driver jdbcDriver = this.getJdbcDriver();
            jdbcDriverClass = jdbcDriver.getClass().getName();
        }
        catch (SQLException e) {
            jdbcDriverClass = "<unknown>";
        }
        StringBuilder builder = new StringBuilder(1024);
        builder.append("driver=").append(jdbcDriverClass).append(System.lineSeparator());
        builder.append("url=").append(this.getConnectionUrl()).append(System.lineSeparator());
        builder.append(this.userCredentials).append(System.lineSeparator());
        return builder.toString();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw this.newSQLFeatureNotSupportedException();
    }

    private Properties createConnectionProperties(String connectionUrl, String user, String password) throws SQLException {
        List<String> skipProperties = Arrays.asList("server", "host", "port", "database", "urlx", "user", "password", URL);
        Driver jdbcDriver = this.getJdbcDriver(connectionUrl);
        DriverPropertyInfo[] propertyInfo = jdbcDriver.getPropertyInfo(this.getConnectionUrl(), new Properties());
        HashMap<String, Boolean> jdbcDriverProperties = new HashMap<String, Boolean>();
        for (DriverPropertyInfo driverPropertyInfo : propertyInfo) {
            String jdbcPropertyName = driverPropertyInfo.name.toLowerCase();
            if (skipProperties.contains(jdbcPropertyName)) continue;
            jdbcDriverProperties.put(jdbcPropertyName, driverPropertyInfo.required);
        }
        Properties jdbcConnectionProperties = new Properties();
        if (user != null) {
            jdbcConnectionProperties.put("user", user);
        }
        if (password != null) {
            jdbcConnectionProperties.put("password", password);
        }
        if (this.connectionProperties != null) {
            for (Map.Entry<String, String> connectionProperty : this.connectionProperties.entrySet()) {
                String property = connectionProperty.getKey();
                String value = connectionProperty.getValue();
                if (!jdbcDriverProperties.containsKey(property.toLowerCase()) || value == null) continue;
                jdbcConnectionProperties.put(property, value);
            }
            Properties urlxConnectionProperties = this.parseConnectionProperties(this.connectionProperties.get("urlx"));
            jdbcConnectionProperties.putAll((Map<?, ?>)urlxConnectionProperties);
        }
        return jdbcConnectionProperties;
    }

    private final Driver getJdbcDriver(String connectionUrl) throws SQLException {
        try {
            return DriverManager.getDriver(connectionUrl);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not find a suitable JDBC driver for database connection URL, " + this.getConnectionUrl(), e);
        }
    }

    private void logConnection(Connection connection) {
        if (connection == null || !LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        try {
            DatabaseMetaData dbMetaData = connection.getMetaData();
            LOGGER.log(Level.INFO, new StringFormat("Connected to %n%s %s %nusing JDBC driver %n%s %s", dbMetaData.getDatabaseProductName(), dbMetaData.getDatabaseProductVersion(), dbMetaData.getDriverName(), dbMetaData.getDriverVersion()));
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not log connection information", (Throwable)e);
        }
    }

    private SQLFeatureNotSupportedException newSQLFeatureNotSupportedException() {
        return new SQLFeatureNotSupportedException("Not supported", "HYC00");
    }

    private Properties parseConnectionProperties(String connectionPropertiesString) {
        Properties urlxProperties = new Properties();
        if (!Utility.isBlank(connectionPropertiesString)) {
            for (String property : connectionPropertiesString.split(";")) {
                String[] propertyValues;
                if (Utility.isBlank(property) || (propertyValues = property.split("=")).length < 2) continue;
                String key = propertyValues[0];
                String value = propertyValues[1];
                if (key == null || value == null) continue;
                urlxProperties.put(key, value);
            }
        }
        return urlxProperties;
    }

    private Properties safeProperties(Properties properties) {
        Properties logProperties = new Properties(properties);
        if (properties.contains("password")) {
            logProperties.put("password", "*****");
        }
        return logProperties;
    }
}

