/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.HashMap;
import java.util.Map;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.OptionsBuilder;
import sf.util.IOUtility;
import sf.util.ObjectToString;
import sf.util.Utility;

public final class InformationSchemaViewsBuilder
implements OptionsBuilder<InformationSchemaViews> {
    private final Map<InformationSchemaKey, String> informationSchemaQueries = new HashMap<InformationSchemaKey, String>();

    public InformationSchemaViewsBuilder fromConfig(Config informationSchemaViewsSql) {
        if (informationSchemaViewsSql == null) {
            return this;
        }
        for (InformationSchemaKey key : InformationSchemaKey.values()) {
            if (!informationSchemaViewsSql.containsKey(key.getLookupKey())) continue;
            try {
                this.informationSchemaQueries.put(key, informationSchemaViewsSql.get(key.getLookupKey()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this;
    }

    public InformationSchemaViewsBuilder fromResourceFolder(String classpath) {
        if (Utility.isBlank(classpath)) {
            return this;
        }
        for (InformationSchemaKey key : InformationSchemaKey.values()) {
            String resource = classpath == null ? key.getResource() : String.format("%s/%s", classpath, key.getResource());
            String sql = IOUtility.readResourceFully(resource);
            if (Utility.isBlank(sql)) continue;
            this.informationSchemaQueries.put(key, sql);
        }
        return this;
    }

    @Override
    public Config toConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InformationSchemaViews toOptions() {
        return new InformationSchemaViews(this.informationSchemaQueries);
    }

    public String toString() {
        return ObjectToString.toString(this.informationSchemaQueries);
    }

    public InformationSchemaViewsBuilder withAdditionalColumnAttributesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withAdditionalTableAttributesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withExtForeignKeysSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_FOREIGN_KEYS, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withExtHiddenTableColumnsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_HIDDEN_TABLE_COLUMNS, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withExtIndexColumnSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_INDEX_COLUMNS, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withExtIndexesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_INDEXES, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withExtPrimaryKeysSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_PRIMARY_KEYS, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withExtTableConstraintsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_TABLE_CONSTRAINTS, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withExtTablesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_TABLES, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withForeignKeysSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.FOREIGN_KEYS, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withIndexesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.INDEXES, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withOverrideTypeInfoSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.OVERRIDE_TYPE_INFO, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withRoutinesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.ROUTINES, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withSchemataSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.SCHEMATA, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withSequencesSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.SEQUENCES, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withSynonymsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.EXT_SYNONYMS, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withTableConstraintsColumnsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.CONSTRAINT_COLUMN_USAGE, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withTableConstraintsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.TABLE_CONSTRAINTS, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withTriggersSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.TRIGGERS, sql);
        return this;
    }

    public InformationSchemaViewsBuilder withViewsSql(String sql) {
        this.informationSchemaQueries.put(InformationSchemaKey.VIEWS, sql);
        return this;
    }
}

