/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.logging.Level;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerCommandLineException;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.options.ApplicationOptions;
import sf.util.Utility;

public final class ApplicationOptionsParser
extends BaseOptionsParser<ApplicationOptions> {
    public ApplicationOptionsParser(Config config) {
        super(config);
        this.normalizeOptionName("loglevel", new String[0]);
        this.normalizeOptionName("help", "?", "h", "-help");
        this.normalizeOptionName("version", "V", "-version");
    }

    @Override
    public ApplicationOptions getOptions() throws SchemaCrawlerCommandLineException {
        ApplicationOptions options = new ApplicationOptions();
        if (this.config.hasValue("loglevel")) {
            String logLevelString = this.config.getStringValue("loglevel", "OFF");
            if (!Utility.isBlank(logLevelString)) {
                Level applicationLogLevel;
                try {
                    applicationLogLevel = Level.parse(logLevelString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new SchemaCrawlerCommandLineException(String.format("Please provide a valid log level, not <%s>", logLevelString), e);
                }
                options.setApplicationLogLevel(applicationLogLevel);
            }
            this.consumeOption("loglevel");
        }
        if (this.config.hasValue("help")) {
            options.setShowHelp(true);
            this.consumeOption("help");
        }
        if (this.config.hasValue("version")) {
            options.setShowHelp(true);
            options.setShowVersionOnly(true);
            this.consumeOption("version");
        }
        return options;
    }
}

