/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.BaseConfigOptionsParser;
import schemacrawler.tools.iosource.FileInputResource;
import schemacrawler.utility.PropertiesUtility;
import sf.util.SchemaCrawlerLogger;

public class ConfigParser
extends BaseConfigOptionsParser {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ConfigParser.class.getName());
    private static final String CONFIG_FILE = "configfile";

    public ConfigParser(Config config) {
        super(config);
        this.normalizeOptionName(CONFIG_FILE, "g");
    }

    public void consumeOptions() {
        this.consumeOption(CONFIG_FILE);
    }

    @Override
    public void loadConfig() throws SchemaCrawlerException {
        try {
            String configfile = this.config.getStringValue(CONFIG_FILE, "schemacrawler.config.properties");
            Path configFilePath = Paths.get(configfile, new String[0]).normalize().toAbsolutePath();
            this.config.putAll(PropertiesUtility.loadConfig(new FileInputResource(configFilePath)));
        }
        catch (IOException e) {
            LOGGER.log(Level.CONFIG, "schemacrawler.config.properties not found in the current directory");
        }
    }
}

