/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseCommandChainExecutable;
import schemacrawler.tools.executable.Commands;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.text.base.CommonTextOptionsBuilder;

public final class CommandDaisyChainExecutable
extends BaseCommandChainExecutable {
    public CommandDaisyChainExecutable(String commands) throws SchemaCrawlerException {
        super(commands);
    }

    @Override
    public void executeOn(Catalog catalog, Connection connection) throws Exception {
        Commands commands = new Commands(this.getCommand());
        if (commands.isEmpty()) {
            throw new SchemaCrawlerException("No command specified");
        }
        for (String command : commands) {
            Executable executable = this.addNext(command);
            if (executable == null) continue;
            CommonTextOptionsBuilder commonTextOptions = new CommonTextOptionsBuilder();
            commonTextOptions.fromConfig(this.additionalConfiguration);
            if (commands.hasMultipleCommands()) {
                if (commands.isFirstCommand(command)) {
                    commonTextOptions.noFooter(true);
                } else if (commands.isLastCommand(command)) {
                    commonTextOptions.noHeader(true);
                    commonTextOptions.noInfo();
                    commonTextOptions.appendOutput();
                } else {
                    commonTextOptions.noHeader(true);
                    commonTextOptions.noInfo();
                    commonTextOptions.noFooter(true);
                    commonTextOptions.appendOutput();
                }
            }
            Config executableAdditionalConfig = new Config();
            if (this.additionalConfiguration != null) {
                executableAdditionalConfig.putAll(this.additionalConfiguration);
            }
            executableAdditionalConfig.putAll(commonTextOptions.toConfig());
            executable.setAdditionalConfiguration(executableAdditionalConfig);
        }
        this.executeChain(catalog, connection);
    }

    private final Executable addNext(String command) throws SchemaCrawlerException {
        try {
            Executable executable = this.commandRegistry.configureNewExecutable(command, this.schemaCrawlerOptions, this.outputOptions);
            if (executable == null) {
                return executable;
            }
            executable.setAdditionalConfiguration(this.additionalConfiguration);
            return this.addNext(executable);
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(String.format("Cannot chain executable, unknown command <%s>", command));
        }
    }
}

