/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.executable.OperationExecutableCommandProvider;
import schemacrawler.tools.executable.SchemaExecutableCommandProvider;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.iosource.StringInputResource;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class CommandRegistry {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(CommandRegistry.class.getName());
    private final List<CommandProvider> commandRegistry = CommandRegistry.loadCommandRegistry();

    private static List<CommandProvider> loadCommandRegistry() throws SchemaCrawlerException {
        ArrayList<CommandProvider> commandProviders = new ArrayList<CommandProvider>();
        commandProviders.add(new SchemaExecutableCommandProvider());
        commandProviders.add(new OperationExecutableCommandProvider());
        try {
            ServiceLoader<CommandProvider> serviceLoader = ServiceLoader.load(CommandProvider.class);
            for (CommandProvider commandProvider : serviceLoader) {
                LOGGER.log(Level.CONFIG, new StringFormat("Loading commands %s, provided by %s", commandProvider.getSupportedCommands(), commandProvider.getClass().getName()));
                commandProviders.add(commandProvider);
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load extended command registry", e);
        }
        return commandProviders;
    }

    public InputResource getHelp(String command) {
        for (CommandProvider commandProvider : this.commandRegistry) {
            if (!commandProvider.getSupportedCommands().contains(command)) continue;
            return commandProvider.getHelp();
        }
        return new StringInputResource("");
    }

    public Collection<String> getSupportedCommands() {
        HashSet<String> supportedCommands = new HashSet<String>();
        for (CommandProvider commandProvider : this.commandRegistry) {
            supportedCommands.addAll(commandProvider.getSupportedCommands());
        }
        return supportedCommands;
    }

    public boolean supportsCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        for (CommandProvider commandProvider : this.commandRegistry) {
            if (!commandProvider.supportsCommand(command, schemaCrawlerOptions, outputOptions)) continue;
            return true;
        }
        return false;
    }

    Executable configureNewExecutable(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) throws SchemaCrawlerException {
        CommandProvider executableCommandProvider = null;
        for (CommandProvider commandProvider : this.commandRegistry) {
            if (!commandProvider.supportsCommand(command, schemaCrawlerOptions, outputOptions)) continue;
            executableCommandProvider = commandProvider;
            break;
        }
        if (executableCommandProvider == null) {
            executableCommandProvider = new OperationExecutableCommandProvider();
        }
        return executableCommandProvider.configureNewExecutable(command, schemaCrawlerOptions, outputOptions);
    }
}

