/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Collection;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.executable.ExecutableCommandProvider;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextExecutable;
import sf.util.Utility;

public final class SchemaExecutableCommandProvider
extends ExecutableCommandProvider {
    private static Collection<String> supportedCommands = SchemaExecutableCommandProvider.supportedCommands();

    private static Collection<String> supportedCommands() {
        ArrayList<String> supportedCommands = new ArrayList<String>();
        for (SchemaTextDetailType schemaTextDetailType : SchemaTextDetailType.values()) {
            supportedCommands.add(schemaTextDetailType.name());
        }
        return supportedCommands;
    }

    public SchemaExecutableCommandProvider() {
        super(supportedCommands, "");
    }

    @Override
    public Executable configureNewExecutable(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) throws SchemaCrawlerException {
        boolean supportsCommand = this.supportsCommand(command, schemaCrawlerOptions, outputOptions);
        if (!supportsCommand) {
            throw new SchemaCrawlerException(String.format("Command <%s> not supported", command));
        }
        SchemaTextExecutable executable = new SchemaTextExecutable(command);
        if (schemaCrawlerOptions != null) {
            executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        }
        if (outputOptions != null) {
            executable.setOutputOptions(outputOptions);
        }
        return executable;
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return SchemaExecutableCommandProvider.supportedCommands();
    }

    @Override
    public boolean supportsCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        if (Utility.isBlank(command) || outputOptions == null) {
            return false;
        }
        String outputFormatValue = outputOptions.getOutputFormatValue();
        return supportedCommands.contains(command) && (Utility.isBlank(outputFormatValue) || TextOutputFormat.isSupportedFormat(outputFormatValue));
    }
}

