/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerCommandLineException;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.CatalogWithAssociations;
import schemacrawler.tools.analysis.counts.CatalogWithCounts;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.integration.graph.GraphExecutor;
import schemacrawler.tools.integration.graph.GraphJavaExecutor;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.integration.graph.GraphOptionsBuilder;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.integration.graph.GraphProcessExecutor;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.schema.SchemaDotFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import schemacrawler.utility.NamedObjectSort;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;

public final class GraphExecutable
extends BaseStagedExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphExecutable.class.getName());
    private GraphOptions graphOptions;

    public GraphExecutable(String command) {
        super(command);
    }

    @Override
    public void executeOn(Catalog db, Connection connection) throws Exception {
        this.loadGraphOptions();
        Catalog catalog = db;
        if (this.graphOptions.isShowWeakAssociations()) {
            catalog = new CatalogWithAssociations(catalog);
        }
        if (this.graphOptions.isShowRowCounts() || this.schemaCrawlerOptions.isHideEmptyTables()) {
            catalog = new CatalogWithCounts(catalog, connection, this.schemaCrawlerOptions);
        }
        GraphOutputFormat graphOutputFormat = GraphOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        this.outputOptions.setOutputFormatValue(graphOutputFormat.getFormat());
        Path dotFile = IOUtility.createTempFilePath("schemacrawler.", "dot");
        OutputOptions dotFileOutputOptions = graphOutputFormat == GraphOutputFormat.scdot ? this.outputOptions : new OutputOptions((OutputFormat)GraphOutputFormat.dot, dotFile);
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler(dotFileOutputOptions);
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog(catalog);
        traverser.setHandler(formatter);
        traverser.setTablesComparator(NamedObjectSort.getNamedObjectSort(this.getGraphOptions().isAlphabeticalSortForTables()));
        traverser.setRoutinesComparator(NamedObjectSort.getNamedObjectSort(this.getGraphOptions().isAlphabeticalSortForRoutines()));
        traverser.traverse();
        if (graphOutputFormat != GraphOutputFormat.scdot) {
            Path outputFile = this.outputOptions.getOutputFile();
            GraphOptions graphOptions = this.getGraphOptions();
            List<String> graphvizOpts = graphOptions.getGraphvizOpts();
            boolean graphGenerated = false;
            if (!graphGenerated) {
                graphGenerated = this.generateGraph(new GraphProcessExecutor(dotFile, outputFile, graphOutputFormat, graphvizOpts));
            }
            if (!graphGenerated) {
                graphGenerated = this.generateGraph(new GraphJavaExecutor(dotFile, outputFile, graphOutputFormat));
            }
            if (!graphGenerated) {
                Path movedDotFile = this.moveDotFile(dotFile, outputFile);
                String message = IOUtility.readResourceFully("/dot.error.txt");
                throw new SchemaCrawlerCommandLineException(String.format("%s%nGenerated DOT file:%n%s", message, movedDotFile == null ? "<failed>" : movedDotFile));
            }
        }
    }

    public final GraphOptions getGraphOptions() {
        this.loadGraphOptions();
        return this.graphOptions;
    }

    public final void setGraphOptions(GraphOptions graphOptions) {
        this.graphOptions = graphOptions;
    }

    private boolean generateGraph(GraphExecutor graphExecutor) {
        Objects.requireNonNull(graphExecutor, "No graph executor provided");
        boolean graphGenerated = false;
        try {
            if (graphExecutor.canGenerate()) {
                graphGenerated = (Boolean)graphExecutor.call();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return graphGenerated;
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = null;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler(OutputOptions outputOptions) throws SchemaCrawlerException {
        GraphOptions graphOptions = this.getGraphOptions();
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        String identifierQuoteString = this.databaseSpecificOptions.getIdentifierQuoteString();
        SchemaDotFormatter formatter = new SchemaDotFormatter(schemaTextDetailType, graphOptions, outputOptions, identifierQuoteString);
        return formatter;
    }

    private void loadGraphOptions() {
        if (this.graphOptions == null) {
            this.graphOptions = new GraphOptionsBuilder().fromConfig(this.additionalConfiguration).toOptions();
        }
    }

    private Path moveDotFile(Path dotFile, Path outputFile) {
        Path movedDotFile = outputFile.normalize().getParent().resolve(outputFile.getFileName() + ".dot");
        try {
            Files.move(dotFile, movedDotFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, String.format("Could not move %s to %s", dotFile, movedDotFile), (Throwable)e);
            return null;
        }
        return movedDotFile;
    }
}

