/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.text.schema.SchemaTextOptionsBuilder;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public class GraphOptionsBuilder
extends SchemaTextOptionsBuilder {
    private static final String GRAPH_SHOW_PRIMARY_KEY_CARDINALITY = "schemacrawler.graph.show.primarykey.cardinality";
    private static final String GRAPH_SHOW_FOREIGN_KEY_CARDINALITY = "schemacrawler.graph.show.foreignkey.cardinality";
    private static final String GRAPH_GRAPHVIZ_OPTS = "schemacrawler.graph.graphviz_opts";
    private static final String SC_GRAPHVIZ_OPTS = "SC_GRAPHVIZ_OPTS";
    private static final String GRAPH_GRAPHVIZ_ATTRIBUTES = "schemacrawler.graph.graphviz";
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphOptions.class.getName());

    public GraphOptionsBuilder() {
        this(new GraphOptions());
    }

    public GraphOptionsBuilder(GraphOptions options) {
        super(options);
    }

    @Override
    public GraphOptionsBuilder fromConfig(Config map) {
        if (map == null) {
            return this;
        }
        super.fromConfig(map);
        Config config = new Config(map);
        GraphOptions options = (GraphOptions)this.options;
        options.setShowPrimaryKeyCardinality(config.getBooleanValue(GRAPH_SHOW_PRIMARY_KEY_CARDINALITY, true));
        options.setShowForeignKeyCardinality(config.getBooleanValue(GRAPH_SHOW_FOREIGN_KEY_CARDINALITY, true));
        options.setGraphvizOpts(this.listGraphvizOpts(this.readGraphvizOpts(config)));
        options.setGraphvizAttributes(this.readGraphvizAttributes(config));
        return this;
    }

    @Override
    public Config toConfig() {
        Config config = super.toConfig();
        GraphOptions options = (GraphOptions)this.options;
        config.setBooleanValue(GRAPH_SHOW_PRIMARY_KEY_CARDINALITY, options.isShowPrimaryKeyCardinality());
        config.setBooleanValue(GRAPH_SHOW_FOREIGN_KEY_CARDINALITY, options.isShowForeignKeyCardinality());
        config.setStringValue(GRAPH_GRAPHVIZ_OPTS, Utility.join(options.getGraphvizOpts(), " "));
        this.graphvizAttributesToConfig(options.getGraphvizAttributes(), config);
        return config;
    }

    @Override
    public GraphOptions toOptions() {
        return (GraphOptions)super.toOptions();
    }

    private void graphvizAttributesToConfig(Map<String, String> graphvizAttributes, Config config) {
        for (Map.Entry<String, String> graphvizAttribute : graphvizAttributes.entrySet()) {
            String fullKey = String.format("%s.%s", GRAPH_GRAPHVIZ_ATTRIBUTES, graphvizAttribute.getKey());
            String value = graphvizAttribute.getValue();
            config.put(fullKey, value);
        }
    }

    private List<String> listGraphvizOpts(String graphVizOptions) {
        List<String> graphVizOptionsList = Arrays.asList(graphVizOptions.split("\\s+"));
        return graphVizOptionsList;
    }

    private Map<String, String> readGraphvizAttributes(Config config) {
        HashMap<String, String> graphvizAttributes = new HashMap<String, String>();
        for (Map.Entry<String, String> configEntry : config.entrySet()) {
            String fullKey = configEntry.getKey();
            if (fullKey == null || !fullKey.startsWith(GRAPH_GRAPHVIZ_ATTRIBUTES)) continue;
            String key = fullKey.substring(GRAPH_GRAPHVIZ_ATTRIBUTES.length() + 1);
            String value = configEntry.getValue();
            graphvizAttributes.put(key, value);
        }
        if (graphvizAttributes.isEmpty()) {
            return null;
        }
        return graphvizAttributes;
    }

    private String readGraphvizOpts(Config config) {
        String scGraphvizOptsCfg = config.getStringValue(GRAPH_GRAPHVIZ_OPTS, "");
        if (!Utility.isBlank(scGraphvizOptsCfg)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using additional Graphviz command-line options from config <%s>", scGraphvizOptsCfg));
            return scGraphvizOptsCfg;
        }
        String scGraphvizOptsProp = System.getProperty(SC_GRAPHVIZ_OPTS);
        if (!Utility.isBlank(scGraphvizOptsProp)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using additional Graphviz command-line options from SC_GRAPHVIZ_OPTS system property <%s>", scGraphvizOptsProp));
            return scGraphvizOptsProp;
        }
        String scGraphvizOptsEnv = System.getenv(SC_GRAPHVIZ_OPTS);
        if (!Utility.isBlank(scGraphvizOptsEnv)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using additional Graphviz command-line options from SC_GRAPHVIZ_OPTS environmental variable <%s>", scGraphvizOptsEnv));
            return scGraphvizOptsEnv;
        }
        return "";
    }
}

