/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.graph.AbstractGraphProcessExecutor;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.utility.ProcessExecutor;
import sf.util.FileContents;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

final class GraphProcessExecutor
extends AbstractGraphProcessExecutor {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphProcessExecutor.class.getName());
    private final List<String> graphvizOpts;

    GraphProcessExecutor(Path dotFile, Path outputFile, GraphOutputFormat graphOutputFormat, List<String> graphvizOpts) throws SchemaCrawlerException {
        super(dotFile, outputFile, graphOutputFormat);
        this.graphvizOpts = Objects.requireNonNull(graphvizOpts, "No Graphviz options provided");
    }

    @Override
    public Boolean call() {
        Integer exitCode;
        List<String> command = this.createDiagramCommand();
        LOGGER.log(Level.INFO, new StringFormat("Generating diagram using Graphviz:\n%s", command.toString()));
        ProcessExecutor processExecutor = new ProcessExecutor();
        processExecutor.setCommandLine(command);
        try {
            exitCode = processExecutor.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, String.format("Could not generate diagram using Graphviz:%n%s", command.toString()), (Throwable)e);
            exitCode = Integer.MIN_VALUE;
        }
        boolean successful = exitCode != null && exitCode == 0;
        LOGGER.log(Level.INFO, new FileContents(processExecutor.getProcessOutput()));
        FileContents processError = new FileContents(processExecutor.getProcessError());
        if (!successful) {
            LOGGER.log(Level.SEVERE, new StringFormat("Process returned exit code %d%n%s", exitCode, processError));
            this.showCommandline(this.outputFile, processExecutor.getCommand());
        } else {
            LOGGER.log(Level.WARNING, processError);
            LOGGER.log(Level.INFO, new StringFormat("Generated diagram <%s>", this.outputFile));
        }
        return successful;
    }

    @Override
    public boolean canGenerate() {
        Integer exitCode;
        ArrayList<String> command = new ArrayList<String>();
        command.add("dot");
        command.add("-V");
        LOGGER.log(Level.INFO, new StringFormat("Checking if Graphviz is available:\n%s", ((Object)command).toString()));
        ProcessExecutor processExecutor = new ProcessExecutor();
        processExecutor.setCommandLine(command);
        try {
            exitCode = processExecutor.call();
            LOGGER.log(Level.INFO, new FileContents(processExecutor.getProcessOutput()));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not execute Graphviz command", (Throwable)e);
            LOGGER.log(Level.WARNING, new FileContents(processExecutor.getProcessError()));
            exitCode = Integer.MIN_VALUE;
        }
        boolean successful = exitCode != null && exitCode == 0;
        return successful;
    }

    private List<String> createDiagramCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("dot");
        command.addAll(this.graphvizOpts);
        command.add("-T");
        command.add(this.graphOutputFormat.getFormat());
        command.add("-o");
        command.add(this.outputFile.toString());
        command.add(this.dotFile.toString());
        return command;
    }

    private void showCommandline(Path outputFile, List<String> command) {
        if (!LOGGER.isLoggable(Level.SEVERE)) {
            return;
        }
        Path movedDotFile = outputFile.normalize().getParent().resolve(outputFile.getFileName() + ".dot");
        command.remove(command.size() - 1);
        command.remove(command.size() - 1);
        command.add(outputFile.toString());
        command.add(movedDotFile.toString());
        LOGGER.log(Level.SEVERE, String.format("%s%nGenerate your diagram manually, using:%n%s", IOUtility.readResourceFully("/dot.error.txt"), String.join((CharSequence)" ", command)));
    }
}

