/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.security.ArrayTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.NamedObject;
import schemacrawler.schemacrawler.BaseCatalogDecorator;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.serialization.SerializableCatalog;

public final class XmlSerializedCatalog
extends BaseCatalogDecorator
implements SerializableCatalog {
    private static final long serialVersionUID = 5314326260124511414L;

    private static XStream newXStream() throws SchemaCrawlerException {
        try {
            String[] immutable;
            String[] mutable;
            XStream xStream = new XStream();
            xStream.addPermission(NoTypePermission.NONE);
            xStream.addPermission(NullPermission.NULL);
            xStream.addPermission(PrimitiveTypePermission.PRIMITIVES);
            xStream.addPermission(ArrayTypePermission.ARRAYS);
            xStream.allowTypeHierarchy(Collection.class);
            xStream.allowTypesByWildcard(new String[]{"schemacrawler.schema.**", "schemacrawler.crawl.**", "java.lang.**", "java.sql.**"});
            xStream.setMode(1002);
            xStream.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

                public boolean canConvert(Class type) {
                    return type != null && LocalDateTime.class.getPackage().equals(type.getPackage());
                }

                public Object fromString(String str) {
                    try {
                        return LocalDateTime.parse(str);
                    }
                    catch (Exception e) {
                        return LocalDateTime.now();
                    }
                }

                public String toString(Object source) {
                    return source.toString();
                }
            }, 5000);
            xStream.registerConverter((Converter)new CollectionConverter(xStream.getMapper()){

                public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                    ArrayList collection = (ArrayList)source;
                    if (collection instanceof Set) {
                        ArrayList list = new ArrayList(collection);
                        Collections.sort(list);
                        collection = list;
                    }
                    for (Object item : collection) {
                        this.writeItem(item, context, writer);
                    }
                }
            }, 5000);
            xStream.registerConverter((Converter)new MapConverter(xStream.getMapper()){

                public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                    Map map = (Map)source;
                    ArrayList entryList = new ArrayList(map.entrySet());
                    Collections.sort(entryList, (o1, o2) -> {
                        Object key1 = ((Map.Entry)o1).getKey();
                        Object key2 = ((Map.Entry)o2).getKey();
                        if (key1 instanceof Comparable && key2 instanceof Comparable) {
                            if (key1 != null) {
                                return ((Comparable)key1).compareTo(key2);
                            }
                            if (key2 != null) {
                                return -1 * ((Comparable)key2).compareTo(key1);
                            }
                            return 0;
                        }
                        return Objects.hashCode(key1) - Objects.hashCode(key2);
                    });
                    for (Object e : entryList) {
                        Map.Entry entry = (Map.Entry)e;
                        ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)this.mapper().serializedClass(Map.Entry.class), Map.Entry.class);
                        this.writeItem(entry.getKey(), context, writer);
                        this.writeItem(entry.getValue(), context, writer);
                        writer.endNode();
                    }
                }
            }, 5000);
            for (String xmlElement : mutable = new String[]{"tableConstraint", "column", "columnDataType", "catalog", "foreignKey", "foreignKeyColumnReference", "index", "indexColumn", "primaryKey", "privilege", "procedure", "procedureColumn", "resultsColumn", "resultsColumns", "table", "trigger", "view"}) {
                xStream.alias(xmlElement, Class.forName("schemacrawler.crawl.Mutable" + xmlElement.substring(0, 1).toUpperCase() + xmlElement.substring(1)));
            }
            for (String xmlElement : immutable = new String[]{"databaseProperty", "jdbcDriverProperty", "schemaCrawlerInfo", "crawlInfo"}) {
                xStream.alias(xmlElement, Class.forName("schemacrawler.crawl.Immutable" + xmlElement.substring(0, 1).toUpperCase() + xmlElement.substring(1)));
            }
            xStream.alias("grant", Class.forName("schemacrawler.crawl.MutablePrivilege$PrivilegeGrant"));
            xStream.alias("schema", Class.forName("schemacrawler.schema.SchemaReference"));
            xStream.omitField(NamedObject.class, "lookupName");
            xStream.omitField(NamedObject.class, "fullName");
            return xStream;
        }
        catch (ClassNotFoundException e) {
            throw new SchemaCrawlerException("Could not load internal classes", e);
        }
    }

    public XmlSerializedCatalog(Catalog catalog) {
        super(catalog);
    }

    public XmlSerializedCatalog(Reader reader) throws SchemaCrawlerException {
        this((Catalog)XmlSerializedCatalog.newXStream().fromXML(reader));
    }

    @Override
    public final <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public final <T> Optional<T> lookupAttribute(String name) {
        return Optional.of(this.getAttribute(name));
    }

    @Override
    public void save(Writer writer) throws SchemaCrawlerException {
        Objects.requireNonNull(writer, "Writer not provided");
        try {
            XmlSerializedCatalog.newXStream().toXML((Object)this.catalog, writer);
            writer.flush();
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Could not write XML", e);
        }
    }
}

