/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.velocity;

import java.io.File;
import java.io.Writer;
import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerCommandLineException;
import schemacrawler.tools.executable.BaseStagedExecutable;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class VelocityRenderer
extends BaseStagedExecutable {
    static final String COMMAND = "velocity";
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(VelocityRenderer.class.getName());

    private static void setVelocityResourceLoaderProperty(Properties p, String resourceLoaderName, String resourceLoaderPropertyName, String resourceLoaderPropertyValue) {
        p.setProperty(resourceLoaderName + "." + "resource.loader" + "." + resourceLoaderPropertyName, resourceLoaderPropertyValue);
    }

    public VelocityRenderer() {
        super(COMMAND);
    }

    @Override
    public final void executeOn(Catalog catalog, Connection connection) throws Exception {
        String templateLocation = this.outputOptions.getOutputFormatValue();
        String templatePath = ".";
        File templateFilePath = new File(templateLocation);
        if (templateFilePath.exists()) {
            templatePath = templatePath + "," + templateFilePath.getAbsoluteFile().getParent();
            templateLocation = templateFilePath.getName();
        }
        VelocityEngine ve = new VelocityEngine();
        String fileResourceLoader = "file";
        String classpathResourceLoader = "classpath";
        Properties p = new Properties();
        p.setProperty("resource.loader", "file,classpath");
        VelocityRenderer.setVelocityResourceLoaderProperty(p, "classpath", "class", ClasspathResourceLoader.class.getName());
        VelocityRenderer.setVelocityResourceLoaderProperty(p, "file", "class", FileResourceLoader.class.getName());
        VelocityRenderer.setVelocityResourceLoaderProperty(p, "file", "path", templatePath);
        LOGGER.log(Level.CONFIG, new StringFormat("Velocity configuration properties <%s>", p.toString()));
        ve.init(p);
        VelocityContext context = new VelocityContext();
        context.put("catalog", (Object)catalog);
        context.put("identifiers", (Object)this.databaseSpecificOptions.getIdentifiers());
        try (Writer writer = this.outputOptions.openNewOutputWriter();){
            String templateEncoding = this.outputOptions.getInputCharset().name();
            LOGGER.log(Level.INFO, new StringFormat("Reading Velocity template <%s>, with encoding <%s>", templateLocation, templateEncoding));
            Template template = ve.getTemplate(templateLocation, templateEncoding);
            template.merge((Context)context, writer);
        }
        catch (ResourceNotFoundException e) {
            throw new SchemaCrawlerCommandLineException("Please specify an Apache Velocity template", e);
        }
    }
}

